/****************************************************************************
 File: clsprn.h

 (C) Copyright 1992 by GO Corporation. All Rights Reserved.

 $Revision:   1.10  $
   $Author:   sbartlet  $
     $Date:   13 Mar 1992 11:34:42  $

 This file contains the app-level API for clsPrn.
 clsPrn inherits from clsOBXService.

 Very few developers would or should deal with instances of clsPrn.  Its
 clients would be those writing print-wrapper applications or printer drivers.
 Both kinds of clients would need far more information than what could be
 described in a header file.

 WARNING: the clsPrn API is likely to change in the future.

 Much more functionality is in clsPrn but things not documented here are
 GO-internal.

****************************************************************************/
#ifndef CLSPRN_INCLUDED
#define CLSPRN_INCLUDED

#ifndef OSHEAP_INCLUDED
#include <osheap.h>
#endif

#ifndef CLSMGR_INCLUDED
#include <clsmgr.h>
#endif

#ifndef OBXSVC_INCLUDED
#include <obxsvc.h>
#endif

#ifndef GEO_INCLUDED
#include <geo.h>
#endif

#pragma pack(1)


/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 *						Common #defines and typedefs					   *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

/****  Popular paper types  ****/

#define prnPaperLetter     0               // all printers
#define prnPaperLegal      1               // Pcl, Postscript
#define prnPaperExec       2               // Pcl
#define prnPaperA4         3               // Pcl, Postscript
#define prnPaperCom10      4               // Pcl
#define prnPaperMonarc     5               // Pcl
#define prnPaperC5         6               // Pcl
#define prnPaperDL         7               // Pcl
#define prnPaperB5         8               // Postscript
#define prnPaperLetterSmall 9              // Postscript
#define prnPaperA4Small   10               // Postscript
#define prnPaperTypeMax   10
#define prnPaperUserDefined 0xffff


/****  Paper metrics  ****/

typedef struct PAPER_CONFIG {   // Paper configuration

   U16     type;                // out: one of paper--- above
   U16     width, height;       // out: paper dimensions in mm
   U16     landScape;           // out:
   U16     nCopies;             // out: # of copies to print

} PAPER_CONFIG, *P_PAPER_CONFIG;


/****  Common header for all printer objects in its FS node  ****/

typedef struct PRN_FS_HDR {

   U16          majorVersion,                   // versioning
                minorVersion;
   PAPER_CONFIG paper;
   U32          portMetricsFPos;
   U16          portMetricsSz;

} PRN_FS_HDR, *P_PRN_FS_HDR;


/****  Error Messages  ****/

#define stsPrnStreamError       MakeStatus(clsPrn,1)
#define stsPrnNoStream          MakeStatus(clsPrn,2)
#define stsPrnUserAbort         MakeStatus(clsPrn,3)
#define stsPrnFntError          MakeStatus(clsPrn,4)


/****  Dialog Messages  ****/
#define tagPrnManualFeedDialog  MakeDialogTag(clsPrn, 0)


/****  Quick Help Id's  ****/
#define tagQhPrnOptions         MakeTag(clsPrn, 12)
#define tagQhPrnModel           MakeTag(clsPrn, 13)
#define tagQhPrnPort            MakeTag(clsPrn, 14)

// Epson driver specific
#define tagQhEpModelSheet       MakeTag(clsEpson, 10)
#define tagQhEpModelList        MakeTag(clsEpson, 11)
#define tagQhEpPaperFeed        MakeTag(clsEpson, 15)

// Pcl   driver specific
#define tagQhPclModelSheet      MakeTag(clsPcl, 10)
#define tagQhPclModelList       MakeTag(clsPcl, 11)
#define tagQhPclPaperFeed       MakeTag(clsPcl, 15)
#define tagQhPclBinding         MakeTag(clsPcl, 16)


/****************************************************************************
 msgNew                 takes P_PRN_NEW, returns STATUS
    category: class message
    Creates a new printer object under the auspices of clsService.
*/
typedef struct PRN_NEW_ONLY {

   U16          model;          // in:  model of printer (subclass defined)
   U16          fsNodeIsNew;    // out: first instantiation of object
   U16          filedDataSz;    // in:  # of bytes to read/write from/to fs node
   P_PRN_FS_HDR pFileData;      // in:  pointer to read/write filed data

} PRN_NEW_ONLY, *P_PRN_NEW_ONLY;

#define prnNewFields \
   obxServiceNewFields \
   PRN_NEW_ONLY prn;

typedef struct PRN_NEW {
   prnNewFields
} PRN_NEW, *P_PRN_NEW;


/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 *                     Device and Page Controls                            *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

/****************************************************************************
 msgPrnGetPaperConfig   takes P_PAPER_CONFIG, returns STATUS
    category: class message
    Get the currently selected paper type, metrics and orientation.
*/
#define msgPrnGetPaperConfig    MakeMsg(clsPrn,2)

/****************************************************************************
 msgPrnSetPaperConfig   takes P_PAPER_CONFIG, returns STATUS
    category: class message
    Set the currently selected paper type, metrics and orientation.
*/
#define msgPrnSetPaperConfig    MakeMsg(clsPrn,3)

/****************************************************************************
 msgPrnGetMetrics       takes P_PRN_METRICS, returns STATUS
    category: descendant responsibility
    Query a printer's device metrics.
*/
#define msgPrnGetMetrics        MakeMsg(clsPrn,12)

typedef struct PRN_METRICS {

   U8  prnType;                 // out: printer type (prnType---)
   U8  cap;                     // out: capability bits

   // minimum scan line count for a band buffer (if one is needed).
   // for dot matrix printers, this should be the pin size (8 or 24)
   U16 minBandSz;

   U32 devPPMX,                 // out: pixel densities:
       devPPMY;                 // out: unit is pixels/meter

   U16 nPlanes;                 // out: Number of planes of the device

   // Number of colors of the device  (note: this number does not
   // necessarily equal (1 << devPlanes) because of halftoning
   U16 nColors;                 // out:

   // currently selected paper metrics in pixels
   U16 width, height;           // out: printable area size
   U16 left, right, top, bottom;// out: unprintable margins

} PRN_METRICS, *P_PRN_METRICS;

                                // PRN_METRICS.prnType
#define prnTypeBm       0       // dot matrix printers
#define prnTypePcl      1       // HP laserjets
#define prnTypePscript  2       // Postscript

                                // PRN_METRICS.cap
#define prnDLBitmap        0x80    // can download bitmap font
#define prnDLOutline       0x40    // can download outline font
#define prnAutoRotate      0x20    // can print in rotated mode
#define prnAutoCopies      0x10    // can print multiple copies of a page
#define prnDuplexPrint     0x08    // can do double-sided printing
#define prnSubbandable     0x04    // can create bandding region of a
                                // portion of a page (relevant to a
                                // banding printer only

/****************************************************************************
 msgPrnStartDoc         takes nothing, returns STATUS
    category: descendant responsibility
    Prepare to start a new document.
*/
#define msgPrnStartDoc          MakeMsg(clsPrn,13)

/****************************************************************************
 msgPrnEndDoc           takes nothing, returns STATUS
    category: descendant responsibility
    End the currently printing document.
*/
#define msgPrnEndDoc            MakeMsg(clsPrn,14)

/****************************************************************************
 msgPrnBeginPage        takes nothing, returns STATUS
    category: descendant responsibility
    Prepare to start a new page.
*/
#define msgPrnBeginPage         MakeMsg(clsPrn,15)

/****************************************************************************
 msgPrnShowPage         takes optional U16, returns STATUS
    category: descendant responsibility
    Output the current page.

 P_ARGS is ignored if the printer can only do single-sided printing.
 P_ARGS is a number specifying page duplexing for printers that can
 do double-sided printing.
*/
#define msgPrnShowPage          MakeMsg(clsPrn,16)

#define prnNextSide   0       // if current side is front, print at back
                                // if current side is back, print at front
                                // msgPrnStartDoc always set the next side
                                // to be the front side.
#define prnFrontSide  1       // print on the front side
#define prnBackSide   2       // print on the back  side

/****************************************************************************
 msgPrnSetCopyCount     takes U32, returns STATUS
    category: descendant responsibility
    Set the copy count.

 Valid only for devices with prnAutoCopies set in the metrics spec
 (msgPrnGetMetrics).
*/
#define msgPrnSetCopyCount      MakeMsg(clsPrn,17)

/****************************************************************************
 msgPrnSetRotation      takes BOOLEAN, returns STATUS
    category: descendant responsibility
    Tell device to operate in 0 or 90 degree mode.

 Note: Change rotation only at the beginning of a new page.

 For printers with the prnAutoRotate capability, sending this
 message in the middle of page formatting will cause undefined
 behavior of the printer. The co-ordinate system of the device
 will be rotated automatically.

 For printers withOUT the prnAutoRotate capability, this message
 will only affect the metrics returned by the msgPrnGetMetrics
 call. The co-ordinate system of the device remains unaffected.

 msgPrnStartDoc will always put the device back into the
 non-rotated mode.
*/
#define msgPrnSetRotation       MakeMsg(clsPrn,18)

/****************************************************************************
 msgPrnEnumModels   takes P_PRN_ENUM_MODELS, returns STATUS
    category: class message
    Enumerate the models that this class supports.
*/
#define msgPrnEnumModels        MakeMsg(clsPrn, 22)

typedef struct {
    U16     model;              // Out: model id (class defined)
    RES_ID  iconResIdNormal;    // Out: resId of model's normal icon
    RES_ID  iconResIdSmall;     // Out: resId of model's small icon
    CHAR    name[nameBufLength];// Out: name of model
} PRN_MODEL, *P_PRN_MODEL;

typedef struct {
  U16              max,         // in = size of pModel[] array
                                
                   count;       // in = # to return in array
                                // if count > max then memory may be allocated
                                // out = # of valid entries in array
                                
  P_PRN_MODEL      pModel;      // in = ptr to array
                                // out = if memory was allocated
                                // client should free the memory
                                
  U16              next;        // in  = 0 to start at beginning 
                                //       OR previous out value to pick up
                                //       where we left off
} PRN_ENUM_MODELS, *P_PRN_ENUM_MODELS;

/****************************************************************************
 msgPrnGetModel     takes P_PRN_MODEL, returns STATUS
    Passes back the receiver's model.
*/
#define msgPrnGetModel          MakeMsg(clsPrn, 23)


/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 *                     Line Printer Mode Support                           *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

/****************************************************************************
 msgPrnMoveTo           takes P_XY32, returns STATUS
    category: descendant responsibility
    Move the printer's 'cursor' to the specified point.
*/
#define msgPrnMoveTo            MakeMsg(clsPrn,19)

/****************************************************************************
 msgPrnGetLptFontMetrics takes P_PRN_TEXTOUT, returns STATUS
    category: descendant responsibility
    Get the metrics/information of a given harware font.
*/
#define msgPrnGetLptFontMetrics MakeMsg(clsPrn,20)

/****************************************************************************
 msgPrnLptTextOut       takes P_PRN_TEXTOUT, returns STATUS
    category: descendant responsibility
    Output a line of text starting from where the printer was
    'msgPrnMoveTo' last.
*/
#define msgPrnLptTextOut        MakeMsg(clsPrn,21)

typedef struct PRN_TEXTOUT {

   U16        nChars;           // in: number of characters to output
   P_CHAR     pStr;             // in: where the string is. Output will
                                // be terminated if a NULL is encountered,
                                // regardless of nChars.

   // additional font attributes subject to printer's capabilities
   U16        fontSz;           // in: big, medium or small
   U16 width, height;           // out: character metrics in pixels

   // transformable attributes:
   // in:  (msgPrnLptTextOut) specifies requested font attributes
// BOOLEAN underline, bold, italic;
   U16     underline, bold, italic;

   // out: (msgPrnGetFontMetrics) tell client what the selected
   //      font is capable of
// BOOLEAN canUnderline, canBold, canItalic;
   U16     canUnderline, canBold, canItalic;

} PRN_TEXTOUT, *P_PRN_TEXTOUT;

#define prnLPTSmall        0       // fontSz field above
#define prnLPTMedium       1
#define prnLPTBig          2

#pragma pack()

#endif  // CLSPRN_INCLUDED
