/****************************************************************************
 File: atalk.h

 (C) Copyright 1992 by GO Corporation, All Rights Reserved.

 $Revision:   1.3  $
   $Author:   rfoster  $
     $Date:   27 Mar 1992 18:15:02  $

 This file contains the API for clsATP.

 clsATP inherits from clsObject.
 Provides remote access to stations using the AppleTalk protocol suite.

****************************************************************************/
#ifndef ATALK_INCLUDED
#define ATALK_INCLUDED

/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 *                         Common typedefs
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

typedef  U8  DDP_TYPE,   * P_DDP_TYPE;
typedef  U8  ATP_FLAGS;

typedef struct ATP_ADDRESS {
	U16	network;
	U8	node;
	U8	socket;
} ATP_ADDRESS,   * P_ATP_ADDRESS;

typedef struct USER_BYTES {
    U8	ub1;
    U8	ub2;
    U8	ub3;
    U8	ub4;
} USER_BYTES,   * P_USER_BYTES;

typedef struct ATP_OPTIONS {
	DDP_TYPE	ddpType;
	ATP_FLAGS	flags;
	U16			transactionID;		// In: transaction id when sending a response
									// Out: transaction id when receiving a request
	U32			interval;			// timeout value in milliseconds
	U16			retries;			// number of times to retry a request
	U8			numUserByteSets;	// In: number of valid user byte sets to send
									// Out: number of valid user byte sets received
	U8			reserved;
	USER_BYTES	userBytes[ 8 ];
} ATP_OPTIONS,   * P_ATP_OPTIONS;

// ATP flags
#define  ATP_XO_Flag				0x01
#define  ATP_Checksum_Flag			0x02
#define  ATP_ALONoResponse_Flag		0x04

typedef		U8		NBP_NAME,   * P_NBP_NAME;

#define		NBP_NAME_Size		99

/* Format for an NBP name is:                    */
/*		U8		objectNameLength;				 */
/*		U8		objectName[ objectNameLength ];	 */
/*		U8		typeNameLength;					 */
/*		U8		typeName[ typeNameLength ];		 */
/*		U8		zoneNameLength;					 */
/*		U8		zoneName[ zoneNameLength ];		 */


typedef U8	NBP_ENUMERATOR;

typedef struct NBP_TUPLE {
	ATP_ADDRESS		address;
	NBP_ENUMERATOR	enumerator;
	NBP_NAME		name[ NBP_NAME_Size ];
} NBP_TUPLE,   * P_NBP_TUPLE;


typedef		U8		ZONES_BUFFER,   * P_ZONES_BUFFER;


/****************************************************************************
 msgNBPRegister		takes P_NBP_REGISTER, returns STATUS

 Registers a name with the network.
*/
#define		msgNBPRegister	MakeMsg( clsATP, 1 )

typedef struct NBP_REGISTER {
	P_NBP_NAME		pName;		// name to register
} NBP_REGISTER,   * P_NBP_REGISTER;


/****************************************************************************
 msgNBPRemove		takes P_NBP_REMOVE, returns STATUS

 Removes a previously registered name from the network.
*/
#define		msgNBPRemove	MakeMsg( clsATP, 2 )

typedef struct NBP_REMOVE {
	P_NBP_NAME		pName;		// name to remove
} NBP_REMOVE,   * P_NBP_REMOVE;


/****************************************************************************
 msgNBPLookup		takes P_NBP_LOOKUP, returns STATUS

 Looks up names registered with the network.
*/
#define		msgNBPLookup	MakeMsg( clsATP, 3 )

typedef struct NBP_LOOKUP {
	P_NBP_NAME			pName;			// name spec to lookup
	P_TP_BUFFER			pBuffer;		// ptr to buffer containing names found
	U16					length;			// size of buffer in bytes
	U16					numMatches;		// In-Out: number of names wanted/found
} NBP_LOOKUP,   * P_NBP_LOOKUP;

/****************************************************************************
 msgNBPConfirm		takes P_NBP_CONFIRM, returns STATUS

 Confirms the network address of a registered name.
*/
#define		msgNBPConfirm	MakeMsg( clsATP, 4 )

typedef struct NBP_CONFIRM {
	P_NBP_NAME			pName;		// name to confirm address of
	P_TP_ADDRESS		pAddress;	// ptr to address of name
} NBP_CONFIRM,   * P_NBP_CONFIRM;





/****************************************************************************
 msgZIPGetZoneList		takes P_ZIP_GETZONES, returns STATUS

 Obtains a list of zone names.
*/
#define		msgZIPGetZoneList	MakeMsg( clsATP, 6 )

typedef struct ZIP_GETZONES {
	P_ZONES_BUFFER			pBuffer;	// ptr to buffer to contain zone names
	U16						length;		// size of buffer in bytes
	U16						numZones;	// Out: number of zones found
} ZIP_GETZONES,   * P_ZIP_GETZONES;


/****************************************************************************
 msgZIPGetMyZone		takes P_ZIP_GETZONES, returns STATUS

 Obtains my zone name.
*/
#define		msgZIPGetMyZone		MakeMsg( clsATP, 7 )


/****************************************************************************
 msgATPRespPktSize		takes P_ATP_RESPPKTSIZE, returns STATUS

 Sets the maximum size of ATP response packets.
*/
#define		msgATPRespPktSize	MakeMsg( clsATP, 8 )

typedef struct ATP_RESPPKTSIZE {
	U16					size;		// max size of response packets in bytes
} ATP_RESPPKTSIZE,   * P_ATP_RESPPKTSIZE;

#endif	/* ATALK_INCLUDED  */
