/****************************************************************************
 File: tttdbg.c

 (C) Copyright 1992 by GO Corporation, All Rights Reserved.

 You may use this Sample Code any way you please provided you 
 do not resell the code and that this notice (including the above 
 copyright notice) is reproduced on all copies.  THIS SAMPLE CODE 
 IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, AND GO CORPORATION 
 EXPRESSLY DISCLAIMS ALL IMPLIED WARRANTIES, INCLUDING BUT NOT 
 LIMITED TO THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A
 PARTICULAR PURPOSE. IN NO EVENT WILL GO CORPORATION BE LIABLE TO YOU 
 FOR ANY CONSEQUENTIAL,INCIDENTAL,OR INDIRECT DAMAGES ARISING OUT OF 
 THE USE OR INABILITY TO USE THIS SAMPLE CODE.

 $Revision:   1.3  $
 $Author:   kcatlin  $
 $Date:   30 Jan 1992 19:15:02  $

 This file contains the implementation of miscellaneous debugging routines
 used by TttApp.  The interfaces to these routines are in tttpriv.h.
****************************************************************************/

#ifndef WIN_INCLUDED
#include <win.h>
#endif

#ifndef VIEW_INCLUDED
#include <view.h>
#endif

#ifndef DEBUG_INCLUDED
#include <debug.h>
#endif

#ifndef OS_INCLUDED
#include <os.h>
#endif

#ifndef APP_INCLUDED
#include <app.h>
#endif

#ifndef FRAME_INCLUDED
#include <frame.h>
#endif

#ifndef CLSMGR_INCLUDED
#include <clsmgr.h>
#endif

#ifndef TTTPRIV_INCLUDED
#include <tttpriv.h>
#endif

#ifndef TTTDATA_INCLUDED
#include <tttdata.h>
#endif

#include <string.h>
#include <ctype.h>


/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 *                          Defines, Types, Globals, Etc				   *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */


/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 *                          Utility Routines							   *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */


/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 *                          Message Handlers							   *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */


/****************************************************************************
	TttDbgDumpWindowTree

	Invoked from debugging menu item to display window tree.
	
	Self must be app.  If the user picked the first command 
	in the submenu, pArgs will be 0, and this handler will 
	dump from the app's mainWin.  Otherwise, it will dump from the app's 
	mainWin's clientWin.
****************************************************************************/

#ifdef DEBUG

MsgHandler(TttDbgDumpWindowTree)
{
	OBJECT		root;
	APP_METRICS am;
	STATUS		s;

	if (((U32)(pArgs)) == 0) {
		ObjCallJmp(msgAppGetMetrics, self, &am, s, Error);
		root = am.mainWin;
	} else {
		StsJmp(TttUtilGetComponents(self, tttGetView, objNull, &root, \
				objNull), s, Error);
	}
	ObjCallJmp(msgWinDumpTree, root, pNull, s, Error);
	return stsOK;
	MsgHandlerParametersNoWarning;

Error:
	return s;
} /* TttDbgDumpWindowTree */

#endif // DEBUG


/****************************************************************************
	TttDbgDumpView
	
	Self must be app.
****************************************************************************/

#ifdef DEBUG

MsgHandler(TttDbgDumpView)
{
	VIEW  	view;
	STATUS	s;

	StsJmp(TttUtilGetComponents(self, tttGetView, objNull, &view, objNull), \
			s, Error);
	ObjCallJmp(msgDump, view, pNull, s, Error);
	return stsOK;
	MsgHandlerParametersNoWarning;

Error:
	return s;
} /* TttDbgDumpView */

#endif // DEBUG


/****************************************************************************
	TttDbgDumpDataObject
	
	Self must be app.
****************************************************************************/

#ifdef DEBUG

MsgHandler(TttDbgDumpDataObject)
{
	OBJECT		dataObject;
	STATUS		s;

	StsJmp(TttUtilGetComponents(self, tttGetDataObject, objNull, objNull, \
			&dataObject), s, Error);
	ObjCallJmp(msgDump, dataObject, pNull, s, Error);
	return stsOK;
	MsgHandlerParametersNoWarning;

Error:
	return s;
} /* TttDbgDumpDataObject */

#endif // DEBUG


/****************************************************************************
	TttDbgChangeTracing
****************************************************************************/

#ifdef DEBUG

MsgHandler(TttDbgChangeTracing)
{
	OBJECT		view;
	OBJECT		dataObject;
	OBJECT		target;
	U32			args = (U32)pArgs;
	U16			targetArg = LowU16(args);
	BOOLEAN		turnTraceOn;
	STATUS		s;

	StsJmp(TttUtilGetComponents(self, tttGetView | tttGetDataObject, objNull, \
			&view, &dataObject), s, Error);

	turnTraceOn = (HighU16(args) == 1);

	if (targetArg == 0) {
		Debugf("Setting tracing of app %s",	turnTraceOn ? "On" : "Off");
		target = self;
	} else if (targetArg == 1) {
		Debugf("Setting tracing of view %s", turnTraceOn ? "On" : "Off");
		target = view;
	} else {
		Debugf("Setting tracing of dataObject %s", turnTraceOn ? "On" : "Off");
		target = dataObject;
	}
	ObjCallWarn(msgTrace, target, (P_ARGS)turnTraceOn);

	return stsOK;
	MsgHandlerParametersNoWarning;

Error:
	return s;
} /* TttDbgChangeTracing */

#endif // DEBUG


/****************************************************************************
	TttDbgForceRepaint
****************************************************************************/

#ifdef DEBUG

MsgHandler(TttDbgForceRepaint)
{
	OBJECT		view;
	STATUS		s;

	StsJmp(TttUtilGetComponents(self, tttGetView, objNull, &view, objNull), \
			s, Error);
	ObjCallJmp(msgWinDirtyRect, view, pNull, s, Error);
	ObjCallJmp(msgWinUpdate, view, pNull, s, Error);
	return stsOK;
	MsgHandlerParametersNoWarning;

Error:
	return s;
} /* TttDbgForceRepaint */

#endif // DEBUG
