/****************************************************************************
 File: tttapp.c

 (C) Copyright 1992 by GO Corporation, All Rights Reserved.

 You may use this Sample Code any way you please provided you 
 do not resell the code and that this notice (including the above 
 copyright notice) is reproduced on all copies.  THIS SAMPLE CODE 
 IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, AND GO CORPORATION 
 EXPRESSLY DISCLAIMS ALL IMPLIED WARRANTIES, INCLUDING BUT NOT 
 LIMITED TO THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A
 PARTICULAR PURPOSE. IN NO EVENT WILL GO CORPORATION BE LIABLE TO YOU 
 FOR ANY CONSEQUENTIAL,INCIDENTAL,OR INDIRECT DAMAGES ARISING OUT OF 
 THE USE OR INABILITY TO USE THIS SAMPLE CODE.

 $Revision:   1.7  $
 $Author:   kcatlin  $
 $Date:   17 Mar 1992 14:08:02  $

 This file contains the implementation of the application class.
****************************************************************************/

#ifndef APP_INCLUDED
#include <app.h>
#endif

#ifndef APPTAG_INCLUDED
#include <apptag.h>
#endif

#ifndef RESFILE_INCLUDED
#include <resfile.h>
#endif

#ifndef FRAME_INCLUDED
#include <frame.h>
#endif

#ifndef DEBUG_INCLUDED
#include <debug.h>
#endif

#ifndef TTTVIEW_INCLUDED
#include <tttview.h>
#endif

#ifndef TTTAPP_INCLUDED
#include <tttapp.h>
#endif

#ifndef TTTDATA_INCLUDED
#include <tttdata.h>
#endif

#ifndef TTTPRIV_INCLUDED
#include <tttpriv.h>
#endif

#ifndef APPMGR_INCLUDED
#include <appmgr.h>
#endif

#ifndef OSHEAP_INCLUDED
#include <osheap.h>
#endif

#ifndef FS_INCLUDED
#include <fs.h>
#endif

#ifndef OPTION_INCLUDED
#include <option.h>
#endif

#include <string.h>

#include <methods.h>

/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 *                          Defines, Types, Globals, Etc	 			   *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */


typedef struct TTT_APP_INST {

	U32	placeHolder;

} TTT_APP_INST,
  * P_TTT_APP_INST,
  * * PP_TTT_APP_INST;


//
// CURRENT_VERSION is the file format version written by this implementation.
// MIN_VERSION is the minimum file format version readable by this 
// implementation.  MAX_VERSION is the maximum file format version readable
// by this implementation.
//
#define CURRENT_VERSION 0
#define MIN_VERSION		0
#define MAX_VERSION		0


typedef TTT_APP_INST
TTT_APP_FILED_0, * P_TTT_APP_FILED_0;


/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 *                          Utility Routines				 			   *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */


/****************************************************************************
	TttAppFiledData0FromInstData

	Computes filed data from instance data.
****************************************************************************/
STATIC void PASCAL
TttAppFiledData0FromInstData(
	P_TTT_APP_INST		pInst,
	P_TTT_APP_FILED_0	pFiled)
{
	*pFiled = *pInst;
} /* TttAppFiledData0FromInstData */


/****************************************************************************
	TttAppInstDataFromFiledData0

	Computes instance data from filed data.
****************************************************************************/
STATIC void PASCAL
TttAppInstDataFromFiledData0(
	P_TTT_APP_FILED_0	pFiled,
	P_TTT_APP_INST		pInst)
{
	*pInst = *pFiled;
} /* TttAppInstDataFromFiledData0 */


/****************************************************************************
	TttAppCheckStationery

	The stationery file is deleted if and only if (1) no errors occur
	during this process and (2) the file is successfully read as a
	stationery file.
****************************************************************************/
#define DbgTttAppCheckStationery(x) \
	TttDbgHelper("TttAppCheckStationery",tttAppDbgSet,0x1,x)

#define STATIONERY_FILE_NAME   "tttstuff.txt"

STATIC STATUS PASCAL
TttAppCheckStationery(
	OBJECT			dataObject)
{
	FS_NEW			fNew;
	TTT_DATA_READ	dataRead;
	BOOLEAN			fileHandleCreated;
	BOOLEAN			deleteTheFile;
	STATUS			s;

	DbgTttAppCheckStationery((""))

	//
	// Initialize for error recovery and freeing resources.  Set return
	// values to something reasonable.
	//
	fNew.object.uid = objNull;
	fileHandleCreated = false;
	deleteTheFile = false;

	//
	// Look for the magic file.  If the file doesn't exist, we're done.
	//
	ObjCallJmp(msgNewDefaults, clsFileHandle, &fNew, s, Error);
	fNew.fs.mode = fsReadOnly;
	fNew.fs.exist = fsNoExistGenError | fsExistOpen;
	fNew.fs.locator.uid = theWorkingDir;
	fNew.fs.locator.pPath = STATIONERY_FILE_NAME;
	s = ObjectCall(msgNew, clsFileHandle, &fNew);
	if (s == stsFSNodeNotFound) {
		DbgTttAppCheckStationery(("file not found; s=0x%lx",s))
		goto NormalExit;
	} else if (s >= stsOK) {
		fileHandleCreated = true;
		DbgTttAppCheckStationery(("file is found"))
	} else {
		DbgTttAppCheckStationery(("Funny status when looking for file"))
		goto Error;
	}

	//
	// Ask the data object to read the file.  If the file is 
	// successfully read as stationery, set up to delete the file.
	// If the file is not successfully read as stationery, simply continue.
	//
	dataRead.fileHandle = fNew.object.uid;
	s = ObjectCall(msgTttDataRead, dataObject, &dataRead);
	if ((s >= stsOK) AND (dataRead.successful)) {
		deleteTheFile = true;
	}

NormalExit:

	//
	// Be sure to close the file handle first;  otherwise the file
	// delete will fail.
	//
	if (fileHandleCreated) {
		ObjCallWarn(msgDestroy, fNew.object.uid, pNull);
	}

	//
	// Perhaps delete the file.  Have to make sure that the file
	// is not read-only before deleting it.  (Alternatively, I could use
	// msgForceDelete, but that's risky.)
	//
	if (deleteTheFile) {
		FS_GET_SET_ATTR	  	set;
		FS_ATTR_LABEL 	  	label = fsAttrFlags;
		FS_NODE_FLAGS_ATTR	attrs;

		//
		// Turn off readOnly.  Don't bother error checking;  even
		// if something goes wrong, we'll go ahead and try to delete 
		// the file, since it might not be readOnly anyhow.
		//
		attrs.mask = fsNodeReadOnly;
		attrs.flags = 0;
		set.pPath = STATIONERY_FILE_NAME;
		set.numAttrs = 1;
		set.pAttrLabels = &label;
		set.pAttrValues = &attrs;
		set.pAttrSizes = pNull;
		ObjCallWarn(msgFSSetAttr, theWorkingDir, &set);

		//
		// Delete the file.  Don't error check.  It would be unfortunate
		// if the file gets left lying around, but there's nothing we can
		// do about it anyhow.  And even if the file is left around,
		// this routine is only called once in an application's lifetime
		// and so there's no risk that we'll use the stationery file
		// instead of the proper file.
		//
		ObjCallWarn(msgFSDelete, theWorkingDir, STATIONERY_FILE_NAME);
		DbgTttAppCheckStationery(("stationery file deleted"))
	}

	DbgTttAppCheckStationery(("returns stsOK"))
	return stsOK;

Error:
	if (fNew.object.uid) {
		ObjCallWarn(msgDestroy, fNew.object.uid, pNull);
	}
	DbgTttAppCheckStationery(("Error; returns 0x%lx",s))
	return s;
} /* TttAppCheckStationery */


/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 *                          Message Handlers  							   *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */


/****************************************************************************
	TttAppInit
	
	Initialize instance data of new object.

	Note: clsmgr has already initialized instance data to zeros.
****************************************************************************/
#define DbgTttAppInit(x) \
	TttDbgHelper("TttAppInit",tttAppDbgSet,0x2,x)

MsgHandler(TttAppInit)
{
	P_TTT_APP_INST	pInst;
	STATUS			s;

	DbgTttAppInit((""))

	//
	// Initialize for error recovery.
	//
	pInst = pNull;

	//
	// Allocate, initialize, and record instance data.
	//
	StsJmp(OSHeapBlockAlloc(osProcessHeapId, SizeOf(*pInst), &pInst), \
			s, Error);
	pInst->placeHolder = -1L;
	ObjectWrite(self, ctx, &pInst);

	DbgTttAppInit(("returns stsOK"))
	return stsOK;
	MsgHandlerParametersNoWarning;

Error:
	if (pInst) {
		OSHeapBlockFree(pInst);
	}
	DbgTttAppInit(("Error; returns 0x%lx",s))
	return s;
} /* TttAppInit */


/****************************************************************************
	TttAppFree
	
	Respond to msgFree.

	Note:  Always return stsOK, even if a problem occurs.  This is
	(1) because there's nothing useful to do if a problem occurs anyhow
	and (2) because the ancestor is called after this function if and
	only if stsOK is returned, and it's important that the ancestor
	get called.
****************************************************************************/
#define DbgTttAppFree(x) \
	TttDbgHelper("TttAppFree",tttAppDbgSet,0x4,x)

MsgHandlerWithTypes(TttAppFree, P_ARGS, PP_TTT_APP_INST)
{
	DbgTttAppFree((""))

	OSHeapBlockFree(*pData);

	DbgTttAppFree(("returns stsOK"))
	return stsOK;
	MsgHandlerParametersNoWarning;
} /* TttAppFree */


/****************************************************************************
	TttAppSave
	
	Save self to a file.
****************************************************************************/
#define DbgTttAppSave(x) \
	TttDbgHelper("TttAppSave",tttAppDbgSet,0x8,x)

MsgHandlerWithTypes(TttAppSave, P_OBJ_SAVE, PP_TTT_APP_INST)
{
	TTT_APP_FILED_0	filed;
	STATUS 			s;

	DbgTttAppSave((""))

	StsJmp(TttUtilWriteVersion(pArgs->file, CURRENT_VERSION), s, Error);
	TttAppFiledData0FromInstData(*pData, &filed);
	StsJmp(TttUtilWrite(pArgs->file, SizeOf(filed), &filed), s, Error);

	DbgTttAppSave(("returns stsOK"))
	return stsOK;
	MsgHandlerParametersNoWarning;

Error:
	DbgTttAppSave(("Error; return 0x%lx",s))
	return s;
} /* TttAppSave */


/****************************************************************************
	TttAppRestore
	
	Restore self from a file.

	Note: clsmgr has already initialized instance data to zeros.
****************************************************************************/
#define DbgTttAppRestore(x) \
	TttDbgHelper("TttAppRestore",tttAppDbgSet,0x10,x)

MsgHandlerWithTypes(TttAppRestore, P_OBJ_RESTORE, PP_TTT_APP_INST)
{
	P_TTT_APP_INST		pInst;
	TTT_APP_FILED_0	filed;
	STATUS 				s;
	TTT_VERSION			version;

	DbgTttAppRestore((""))

	//
	// Initialize for error recovery.
	//
	pInst = pNull;

	//
	// Read version, then read filed data.  (Currently there's only
	// only one legitimate file format, so no checking of the version
	// need be done.)
	//
	// The allocate instance data and convert filed data.
	//
			
	StsJmp(TttUtilReadVersion(pArgs->file, MIN_VERSION, MAX_VERSION, \
			&version), s, Error);
	StsJmp(TttUtilRead(pArgs->file, SizeOf(filed), &filed), s, Error);
	StsJmp(OSHeapBlockAlloc(osProcessHeapId, SizeOf(*pInst), &pInst), \
			s, Error);
	TttAppInstDataFromFiledData0(&filed, pInst);

	ObjectWrite(self, ctx, &pInst);
	DbgTttAppRestore(("returns stsOK"))
	return stsOK;
	MsgHandlerParametersNoWarning;

Error:
	if (pInst) {
		OSHeapBlockFree(pInst);
	}
	DbgTttAppRestore(("Error; returns 0x%lx",s))
	return s;
} /* TttAppRestore */


/****************************************************************************
	TttAppDump
	
	Respond to msgDump.
****************************************************************************/

#ifdef DEBUG

MsgHandlerWithTypes(TttAppDump, P_ARGS, PP_TTT_APP_INST)
{
	Debugf("TttAppDump: placeHolder=%ld", (U32)((*pData)->placeHolder));
	return stsOK;
	MsgHandlerParametersNoWarning;
} /* TttAppDump */

#endif // DEBUG


/****************************************************************************
	TttAppAppInit
	
	Respond to msgAppInit.	Perform one-time app life-cyle initializations.
****************************************************************************/
#define DbgTttAppAppInit(x) \
	TttDbgHelper("TttAppAppInit",tttAppDbgSet,0x20,x)

MsgHandlerWithTypes(TttAppAppInit, P_ARGS, PP_TTT_APP_INST)
{
	APP_METRICS		am;
	TTT_VIEW_NEW	tttViewNew;
	BOOLEAN			responsibleForView;
	BOOLEAN			responsibleForScrollWin;
	OBJECT			dataObject;
	OBJECT			scrollWin;
	STATUS			s;

	DbgTttAppAppInit((""))

	//
	// Initialize for error recovery.
	//
	tttViewNew.object.uid = objNull;
	scrollWin = objNull;
	responsibleForView = false;
	responsibleForScrollWin = false;

	//
	// Create and initialize view.  This creates and initializes
	// data object as well.
	//
	ObjCallJmp(msgNewDefaults, clsTttView, &tttViewNew, s, Error);
	ObjCallJmp(msgNew, clsTttView, &tttViewNew, s, Error);
	responsibleForView = true;

	//
	// Check for stationery.
	//
	ObjCallJmp(msgViewGetDataObject, tttViewNew.object.uid, \
			&dataObject, s, Error);
	StsJmp(TttAppCheckStationery(dataObject), s, Error);

	//
	// Create and initialize scrollWin.
	//
	StsJmp(TttUtilCreateScrollWin(tttViewNew.object.uid, &scrollWin), \
			s, Error);
	responsibleForScrollWin = true;
	responsibleForView = false;

	//
	// Make the scrollWin be the frame's client win.
	//
	ObjCallJmp(msgAppGetMetrics, self, &am, s, Error);
	ObjCallJmp(msgFrameSetClientWin, am.mainWin, (P_ARGS)scrollWin, s, Error);
	responsibleForScrollWin = false;

	DbgTttAppAppInit(("returns stsOK"))
	return stsOK;
	MsgHandlerParametersNoWarning;

Error:
	if (responsibleForView AND tttViewNew.object.uid) {
		ObjCallWarn(msgDestroy, tttViewNew.object.uid, pNull);
	}
	if (responsibleForScrollWin AND scrollWin) {
		ObjCallWarn(msgDestroy, scrollWin, pNull);
	}
	DbgTttAppAppInit(("Error; returns 0x%lx",s))
	return s;
} /* TttAppAppInit */


/****************************************************************************
	TttAppOpen
	
	Respond to msgAppOpen.

	It's important that the ancestor be called AFTER all the frame
	manipulations in this routine because the ancestor takes care of any
	layout that is necessary.
****************************************************************************/
#define DbgTttAppOpen(x) \
	TttDbgHelper("TttAppOpen",tttAppDbgSet,0x40,x)

//
// Really a P_TK_TABLE_ENTRY
//
extern P_UNKNOWN tttMenuBar;

MsgHandlerWithTypes(TttAppOpen, P_ARGS, PP_TTT_APP_INST)
{
	APP_METRICS		am;
	OBJECT			menu;
	BOOLEAN			menuAdded;
	STATUS			s;

	DbgTttAppOpen((""))

	//
	// Initialize for error recovery.
	//
	menu = objNull;
	menuAdded = false;

	//
	// Get app and frame metrics.
	//
	ObjCallJmp(msgAppGetMetrics, self, &am, s, Error);

	//
	// Create and add menu bar.
	//
	StsJmp(TttUtilCreateMenu(am.mainWin, self, tttMenuBar, &menu), s, Error);
	DbgTttAppOpen(("menu=0x%lx",menu));
	ObjCallJmp(msgAppCreateMenuBar, self, &menu, s, Error);
	StsJmp(TttUtilAdjustMenu(menu), s, Error);
	ObjCallJmp(msgFrameSetMenuBar, am.mainWin, (P_ARGS)menu, s, Error);
	menuAdded = true;

	DbgTttAppOpen(("returns stsOK"))
	return stsOK;
	MsgHandlerParametersNoWarning;

Error:
	if (menuAdded) {
		ObjCallWarn(msgFrameDestroyMenuBar, am.mainWin, pNull);
	}  else if (menu) {
		ObjCallWarn(msgDestroy, menu, pNull);
	}
	DbgTttAppOpen(("Error; return 0x%lx",s))
	return s;
} /* TttAppOpen */


/****************************************************************************
	TttAppClose
	
	Respond to msgAppClose.

	Be sure that the ancestor is called FIRST.  The ancestor extracts the
	frame, and we want the frame extracted before performing surgery on
	it.
****************************************************************************/
#define DbgTttAppClose(x) \
	TttDbgHelper("TttAppClose",tttAppDbgSet,0x80,x)

MsgHandlerWithTypes(TttAppClose, P_ARGS, PP_TTT_APP_INST)
{
	APP_METRICS		am;
	STATUS      	s;

	DbgTttAppClose((""))

	//
	// Get the frame.  Extract the menu bar from the frame.  Then
	// free the menu bar.
	//
	ObjCallJmp(msgAppGetMetrics, self, &am, s, Error);
	ObjCallJmp(msgFrameDestroyMenuBar, am.mainWin, pNull, s, Error);

	DbgTttAppClose(("returns stsOK"))
	return stsOK;
	MsgHandlerParametersNoWarning;

Error:
	DbgTttAppClose(("Error; return 0x%lx",s))
	return s;
} /* TttAppClose */


/****************************************************************************
	TttAppSelectAll
****************************************************************************/
#define DbgTttAppSelectAll(x) \
	TttDbgHelper("TttAppSelectAll",tttAppDbgSet,0x200,x)

MsgHandlerWithTypes(TttAppSelectAll, P_ARGS, PP_TTT_APP_INST)
{
	OBJECT	view;
	STATUS	s;

	DbgTttAppSelectAll((""))

	StsJmp(TttUtilGetComponents(self, tttGetView, pNull, &view, pNull),
			s, Error);
	ObjCallJmp(msgTttViewTakeSel, view, pNull, s, Error);

	DbgTttAppSelectAll(("returns stsOK"))
	return stsOK;
	MsgHandlerParametersNoWarning;

Error:
	DbgTttAppSelectAll(("Error; return 0x%lx",s))
	return s;
} /* TttAppSelectAll */


/****************************************************************************
	TttAppProvideEnable
	
	Respond to msgControlProvideEnable.
****************************************************************************/
MsgHandlerWithTypes(TttAppProvideEnable, P_CONTROL_PROVIDE_ENABLE, PP_TTT_APP_INST)
{
	switch (pArgs->tag) {
		case (tagAppMenuSelectAll):
			pArgs->enable = true;
			break;
		default:
			return ObjectCallAncestorCtx(ctx);
	}

	return stsOK;
	MsgHandlerParametersNoWarning;

}

/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 *                          Installation	   					   		   *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */


/****************************************************************************
	ClsTttAppInit
	
	Install the application.
****************************************************************************/
STATUS PASCAL
ClsTttAppInit (void)
{
	APP_MGR_NEW	new;
	STATUS		s;

	ObjCallJmp(msgNewDefaults, clsAppMgr, &new, s, Error);
	new.object.uid	         		= clsTttApp;
	new.object.key 	      			= 0;
	new.cls.pMsg		         	= clsTttAppTable;
	new.cls.ancestor	      		= clsApp;
	new.cls.size		         	= SizeOf(P_TTT_APP_INST);
	new.cls.newArgsSize         	= SizeOf(APP_NEW);
	new.appMgr.flags.stationery		= true;
	new.appMgr.flags.accessory		= false;
	strcpy(new.appMgr.company, "GO Corporation");

	// 213 (octal) is the "circle-c" copyright symbol
	new.appMgr.copyright = "\213 1992 GO Corporation, All Rights Reserved.";
	ObjCallJmp(msgNew, clsAppMgr, &new, s, Error);

	return stsOK;

Error:
	return s;
} /* ClsTttAppInit  */


/****************************************************************************
	main
	
	Main application entry point.
****************************************************************************/

STATUS EXPORTED TttSymbolsInit(void);

void CDECL
main(
	int			argc,
	char *		argv[],
	U16			processCount)
{

	if (processCount == 0) {

		TttSymbolsInit();

		StsWarn(ClsTttAppInit());
		StsWarn(ClsTttViewInit());
		StsWarn(ClsTttDataInit());

		AppMonitorMain(clsTttApp, objNull);

	}  	else {

		AppMain();
	}
	// Suppress compiler's "unused parameter" warnings
	Unused(argc); Unused(argv); 
} /* main */

