/****************************************************************************
 File: tktables.c

 (C) Copyright 1992 by GO Corporation, All Rights Reserved.

 You may use this Sample Code any way you please provided you 
 do not resell the code and that this notice (including the above 
 copyright notice) is reproduced on all copies.  THIS SAMPLE CODE 
 IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, AND GO CORPORATION 
 EXPRESSLY DISCLAIMS ALL IMPLIED WARRANTIES, INCLUDING BUT NOT 
 LIMITED TO THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A
 PARTICULAR PURPOSE. IN NO EVENT WILL GO CORPORATION BE LIABLE TO YOU 
 FOR ANY CONSEQUENTIAL,INCIDENTAL,OR INDIRECT DAMAGES ARISING OUT OF 
 THE USE OR INABILITY TO USE THIS SAMPLE CODE.

 $Revision:   1.6  $
   $Author:   kcatlin  $
     $Date:   05 Feb 1992 09:07:06  $

 This file contains the clsTkTable demoing code of the tkdemo application.
****************************************************************************/

#ifndef OPTTABLE_INCLUDED
#include <opttable.h>
#endif

#ifndef SWIN_INCLUDED
#include <swin.h>
#endif

#ifndef BUTTON_INCLUDED
#include <button.h>
#endif

#ifndef MENU_INCLUDED
#include <menu.h>
#endif

#ifndef CHOICE_INCLUDED
#include <choice.h>
#endif

#ifndef TTABLE_INCLUDED
#include <ttable.h>
#endif

#ifndef TABBAR_INCLUDED
#include <tabbar.h>
#endif

#ifndef TKDEMO_INCLUDED
#include <tkdemo.h>
#endif


// simple menu
static const TK_TABLE_ENTRY sampleMenu[] = {
	{"This"},
	{"That"},
	{"Other"},
	{pNull}
};

// menu with simple menu as pull-right
static const TK_TABLE_ENTRY samplePullRight[] = {
	{"Courier"},
	{"Helvetica"},
	{"Other", 0, 0, 0, tkMenuPullRight},
		{"This"},
		{"That"},
		{"Other"},
		{pNull},
	{pNull}
};


// menu bar with inline pull-down menus, one with pull-right
static const TK_TABLE_ENTRY sampleMenuBar[] = {
	{"Font", 0, 0, 0, tkMenuPullDown},
		{"Times Roman"},
		{"Squire"},
		{"More", 0, 0, 0, tkMenuPullRight},
			{"Helvetica"},
			{"Courier"},
			{pNull},
		{pNull},

	{"Edit", 0, 0, 0, tkMenuPullDown},
		{"Document"},
		{"Volume"},
		{pNull},
	{pNull}
};

// choice with one button on
#define	tagSmall	1
#define	tagMedium	2
#define	tagLarge	3
#define	tagOther	4

static const TK_TABLE_ENTRY sampleChoice[] = {
	{"Small", 0, 0, tagSmall},
	{"Medium", 0, 0, tagMedium, tkButtonOn},
	{"Large", 0, 0, tagLarge},
	{pNull}
};


static const TK_TABLE_ENTRY sampleComplexChoice[] = {
	{"Small", 0, 0, tagSmall},
	{"Medium", 0, 0, tagMedium, tkButtonOn},
	{"Large", 0, 0, tagLarge},
	{0, 0, 0, tagOther, tkLabelEntry},
		{0, 0, 0, 0, tkTableHorizontal, clsTkTable},
			{"From", 0, 0, 0, tkBorderMarginNone, clsLabel},
			{"1", 3, 0, 0, 0, clsIntegerField},
			{"to", 0, 0, 0, tkBorderMarginNone, clsLabel},
			{"1", 3, 0, 0, 0, clsIntegerField},
			{pNull},
	{pNull}
};

static const TK_TABLE_ENTRY sampleToggleTable[] = {
	{"Bold", 0, 0, 0, tkButtonOn},
	{"Italic"},
	{"Underline", 0, 0, 0, tkButtonOn},
	{pNull}
};

static const TK_TABLE_ENTRY sampleTabBar[] = {
	{"Card 1"},
	{"Card 2"},
	{"Card 3"},
	{pNull}
};

/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 *								Local Utilities	  					   	   *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */


STATUS LOCAL AddTkTableExamples (WIN	parent)
{
	STATUS				s;
	TK_TABLE_NEW		ttn;
	MENU_NEW			mn;
	CHOICE_NEW			cn;
	TOGGLE_TABLE_NEW	tn;
	TAB_BAR_NEW			tbn;
    WIN                 w;
    TBL_LAYOUT_METRICS  tm;

	AddLabel(parent, "Default");

	ObjCallRet(msgNewDefaults, clsTkTable, &ttn, s);
	ttn.tkTable.pEntries = sampleMenu;
	ObjCallRet(msgNew, clsTkTable, &ttn, s);

	ttn.win.parent = parent;
	ObjCallRet(msgWinInsert, ttn.object.uid, &ttn.win, s);

	AddLabel(parent, "Menu");

	ObjCallRet(msgNewDefaults, clsMenu, &mn, s);
	mn.tkTable.pEntries = sampleMenu;
	mn.menu.style.type = msTypeMenu;
	ObjCallRet(msgNew, clsMenu, &mn, s);

	mn.win.parent = parent;
	ObjCallRet(msgWinInsert, mn.object.uid, &mn.win, s);

	AddLabel(parent, "Menu with Pull-Right");

	ObjCallRet(msgNewDefaults, clsMenu, &mn, s);
	mn.tkTable.pEntries = samplePullRight;
	mn.menu.style.type = msTypeMenu;
	ObjCallRet(msgNew, clsMenu, &mn, s);

	mn.win.parent = parent;
	ObjCallRet(msgWinInsert, mn.object.uid, &mn.win, s);

	AddLabel(parent, "Menu Bar");

	ObjCallRet(msgNewDefaults, clsMenu, &mn, s);
	mn.tkTable.pEntries = sampleMenuBar;
	ObjCallRet(msgNew, clsMenu, &mn, s);

	mn.win.parent = parent;
	ObjCallRet(msgWinInsert, mn.object.uid, &mn.win, s);

	AddLabel(parent, "Exclusive Choice");

	ObjCallRet(msgNewDefaults, clsChoice, &cn, s);
	cn.tkTable.pEntries = sampleChoice;
	ObjCallRet(msgNew, clsChoice, &cn, s);

	cn.win.parent = parent;
	ObjCallRet(msgWinInsert, cn.object.uid, &cn.win, s);

	AddLabel(parent, "Exclusive Choice with Complex Choice");

	ObjCallRet(msgNewDefaults, clsChoice, &cn, s);
	cn.tkTable.pEntries = sampleComplexChoice;
	ObjCallRet(msgNew, clsChoice, &cn, s);

    // Use baseline y alignment on the complex choice's "other" entry
    w = (WIN) ObjectCall(msgWinFindTag, cn.object.uid, (P_ARGS) tagOther);
    ObjCallRet(msgLabelGetWin, w, &w, s);
    ObjCallRet(msgTblLayoutGetMetrics, w, &tm, s);
    tm.style.childYAlignment = tlAlignBaseline;
    tm.rowHeight.constraint = tlGroupMax | tlBaselineBox;
    ObjCallRet(msgTblLayoutSetMetrics, w, &tm, s);

	cn.win.parent = parent;
	ObjCallRet(msgWinInsert, cn.object.uid, &cn.win, s);

	AddLabel(parent, "Toggle Table (Non-Exclusive Choice)");

	ObjCallRet(msgNewDefaults, clsToggleTable, &tn, s);
	tn.tkTable.pEntries = sampleToggleTable;
	ObjCallRet(msgNew, clsToggleTable, &tn, s);

	tn.win.parent = parent;
	ObjCallRet(msgWinInsert, tn.object.uid, &tn.win, s);

	AddLabel(parent, "Tab Bar");

	ObjCallRet(msgNewDefaults, clsTabBar, &tbn, s);
	tbn.tkTable.pEntries = sampleTabBar;
	tbn.tkTable.pButtonNew->label.scale = lsScaleJumbo;
	ObjCallRet(msgNew, clsTabBar, &tbn, s);

	tbn.win.parent = parent;
	ObjCallRet(msgWinInsert, tbn.object.uid, &tbn.win, s);

	return stsOK;
}


/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 *								Global Utilities						   *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

STATUS GLOBAL TkDemoAddTkTablesCard (
	WIN		swin,
	WIN		tabBar,
	APP		app)
{
	STATUS				s;
	OPTION_TABLE_NEW	otn;

	// Create the card window.
	ObjCallRet(msgNewDefaults, clsOptionTable, &otn, s);
	otn.tableLayout.style.childXAlignment = tlAlignLeft;
	ObjCallRet(msgNew, clsOptionTable, &otn, s);

	// Add it to the scrollwin.
	ObjCallRet(msgScrollWinAddClientWin, swin, (P_ARGS) otn.object.uid, s);

	// Create and add a corresponding tab.
	StsRet(AddTab(tabBar, "TkTables", otn.object.uid), s);

	// fill the card with border examples
	StsRet(AddTkTableExamples(otn.object.uid), s);

	return stsOK;

	Unused(app);
}


