/****************************************************************************
 File: labels.c

 (C) Copyright 1992 by GO Corporation, All Rights Reserved.

 You may use this Sample Code any way you please provided you 
 do not resell the code and that this notice (including the above 
 copyright notice) is reproduced on all copies.  THIS SAMPLE CODE 
 IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, AND GO CORPORATION 
 EXPRESSLY DISCLAIMS ALL IMPLIED WARRANTIES, INCLUDING BUT NOT 
 LIMITED TO THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A
 PARTICULAR PURPOSE. IN NO EVENT WILL GO CORPORATION BE LIABLE TO YOU 
 FOR ANY CONSEQUENTIAL,INCIDENTAL,OR INDIRECT DAMAGES ARISING OUT OF 
 THE USE OR INABILITY TO USE THIS SAMPLE CODE.

 $Revision:   1.5  $
   $Author:   kcatlin  $
     $Date:   31 Jan 1992 08:44:18  $

 This file contains the clsLabel demoing code of the tkdemo application.
****************************************************************************/

#ifndef OPTTABLE_INCLUDED
#include <opttable.h>
#endif

#ifndef SWIN_INCLUDED
#include <swin.h>
#endif

#ifndef LABEL_INCLUDED
#include <label.h>
#endif

#ifndef TKDEMO_INCLUDED
#include <tkdemo.h>
#endif



/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 *								Local Utilities	  					   	   *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */


STATUS LOCAL AddLabelExamples (WIN	parent)
{
	STATUS				s;
	LABEL_NEW			ln;
	BORDER_NEW			bn;

	AddLabel(parent, "Left Justified");

	ObjCallRet(msgNewDefaults, clsLabel, &ln, s);
	ln.border.style.edge = bsEdgeAll;
	ln.label.pString = "Label";
	ObjCallRet(msgNew, clsLabel, &ln, s);

	ln.win.parent = parent;
	ObjCallRet(msgWinInsert, ln.object.uid, &ln.win, s);

	AddLabel(parent, "Centered");

	ObjCallRet(msgNewDefaults, clsLabel, &ln, s);
	ln.border.style.edge = bsEdgeAll;
	ln.label.style.xAlignment = lsAlignCenter;
	ln.label.style.numCols = lsNumAbsolute;
	ln.label.cols = 10;
	ln.label.pString = "Label";
	ObjCallRet(msgNew, clsLabel, &ln, s);

	ln.win.parent = parent;
	ObjCallRet(msgWinInsert, ln.object.uid, &ln.win, s);

	AddLabel(parent, "Right Justified");

	ObjCallRet(msgNewDefaults, clsLabel, &ln, s);
	ln.border.style.edge = bsEdgeAll;
	ln.label.style.xAlignment = lsAlignRight;
	ln.label.style.numCols = lsNumAbsolute;
	ln.label.cols = 10;
	ln.label.pString = "Label";
	ObjCallRet(msgNew, clsLabel, &ln, s);

	ln.win.parent = parent;
	ObjCallRet(msgWinInsert, ln.object.uid, &ln.win, s);

	AddLabel(parent, "Word Wrap");

	ObjCallRet(msgNewDefaults, clsLabel, &ln, s);
	ln.border.style.edge = bsEdgeAll;
	ln.label.style.wordWrap = true;
	ln.label.style.numCols = lsNumAbsolute;
	ln.label.cols = 10;
	ln.label.pString = "Now is the time for all good men to";
	ObjCallRet(msgNew, clsLabel, &ln, s);

	ln.win.parent = parent;
	ObjCallRet(msgWinInsert, ln.object.uid, &ln.win, s);

	AddLabel(parent, "Left Decoration");

	ObjCallRet(msgNewDefaults, clsLabel, &ln, s);
	ln.label.style.decoration = lsDecorationCheck;
	ln.label.pString = "Label";
	ObjCallRet(msgNew, clsLabel, &ln, s);

	ln.win.parent = parent;
	ObjCallRet(msgWinInsert, ln.object.uid, &ln.win, s);

	AddLabel(parent, "Right Decoration");

	ObjCallRet(msgNewDefaults, clsLabel, &ln, s);
	ln.label.style.decoration = lsDecorationPullRight;
	ln.label.pString = "Label";
	ObjCallRet(msgNew, clsLabel, &ln, s);

	ln.win.parent = parent;
	ObjCallRet(msgWinInsert, ln.object.uid, &ln.win, s);

	AddLabel(parent, "Custom Font");

	ObjCallRet(msgNewDefaults, clsLabel, &ln, s);
	ln.label.style.fontType = lsFontCustom;
	ln.label.fontName = "CR65";
	ln.label.pString = "Label";
	ObjCallRet(msgNew, clsLabel, &ln, s);

	ln.win.parent = parent;
	ObjCallRet(msgWinInsert, ln.object.uid, &ln.win, s);

	AddLabel(parent, "Bold System Font");

	ObjCallRet(msgNewDefaults, clsLabel, &ln, s);
	ln.label.style.fontType = lsFontCustom;
	ln.label.font.attr.weight = sysDcWeightBold;
	ln.label.pString = "Label";
	ObjCallRet(msgNew, clsLabel, &ln, s);

	ln.win.parent = parent;
	ObjCallRet(msgWinInsert, ln.object.uid, &ln.win, s);

	AddLabel(parent, "Small");

	ObjCallRet(msgNewDefaults, clsLabel, &ln, s);
	ln.label.scale = lsScaleSmall;
	ln.label.pString = "Label";
	ObjCallRet(msgNew, clsLabel, &ln, s);

	ln.win.parent = parent;
	ObjCallRet(msgWinInsert, ln.object.uid, &ln.win, s);

	AddLabel(parent, "Jumbo");

	ObjCallRet(msgNewDefaults, clsLabel, &ln, s);
	ln.label.scale = lsScaleJumbo;
	ln.label.pString = "Label";
	ObjCallRet(msgNew, clsLabel, &ln, s);

	ln.win.parent = parent;
	ObjCallRet(msgWinInsert, ln.object.uid, &ln.win, s);

	AddLabel(parent, "Rotated");

	ObjCallRet(msgNewDefaults, clsLabel, &ln, s);
	ln.border.style.edge = bsEdgeAll;
	ln.label.style.rotation = lsRotate90;
	ln.label.style.xAlignment = lsAlignCenter;
	ln.label.pString = "Label";
	ObjCallRet(msgNew, clsLabel, &ln, s);

	ln.win.parent = parent;
	ObjCallRet(msgWinInsert, ln.object.uid, &ln.win, s);

	AddLabel(parent, "Embedded Child Window");

	ObjCallRet(msgNewDefaults, clsBorder, &bn, s);
	bn.win.bounds.size.w = 40;
	bn.win.bounds.size.h = 20;
	bn.border.style.backgroundInk = bsInkGray66;
	ObjCallRet(msgNew, clsBorder, &bn, s);

	ObjCallRet(msgNewDefaults, clsLabel, &ln, s);
	ln.border.style.edge = bsEdgeAll;
	ln.label.style.infoType = lsInfoWindow;
	ln.label.style.decoration = lsDecorationCheck;
	ln.label.pString = (P_STRING) bn.object.uid;
	ObjCallRet(msgNew, clsLabel, &ln, s);

	ln.win.parent = parent;
	ObjCallRet(msgWinInsert, ln.object.uid, &ln.win, s);

	return stsOK;

} /* AddLabelExamples */


/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 *								Global Utilities						   *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

STATUS GLOBAL TkDemoAddLabelsCard (
	WIN		swin,
	WIN		tabBar,
	APP		app)
{
	STATUS				s;
	OPTION_TABLE_NEW	otn;

	// Create the card window.
	ObjCallRet(msgNewDefaults, clsOptionTable, &otn, s);
	otn.tableLayout.style.childXAlignment = tlAlignLeft;
	ObjCallRet(msgNew, clsOptionTable, &otn, s);

	// Add it to the scrollwin.
	ObjCallRet(msgScrollWinAddClientWin, swin, (P_ARGS) otn.object.uid, s);

	// Create and add a corresponding tab.
	StsRet(AddTab(tabBar, "Labels", otn.object.uid), s);

	// fill the card with border examples
	StsRet(AddLabelExamples(otn.object.uid), s);

	return stsOK;

	Unused(app);

} /* TkDemoAddLabelsCard */


