/****************************************************************************
 $Workfile:   PAPP.C  $

 (C) Copyright 1992 by GO Corporation, All Rights Reserved.

 You may use this Sample Code any way you please provided you 
 do not resell the code and that this notice (including the above 
 copyright notice) is reproduced on all copies.  THIS SAMPLE CODE 
 IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, AND GO CORPORATION 
 EXPRESSLY DISCLAIMS ALL IMPLIED WARRANTIES, INCLUDING BUT NOT 
 LIMITED TO THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A
 PARTICULAR PURPOSE. IN NO EVENT WILL GO CORPORATION BE LIABLE TO YOU 
 FOR ANY CONSEQUENTIAL,INCIDENTAL,OR INDIRECT DAMAGES ARISING OUT OF 
 THE USE OR INABILITY TO USE THIS SAMPLE CODE.

 $Revision:   1.8  $
   $Author:   kcatlin  $
     $Date:   18 Mar 1992 09:07:26  $

 This file contains the Paint app.
****************************************************************************/

#include <stdio.h>
#include <string.h>
#include <go.h>
#include <uid.h>
#include <clsmgr.h>
#include <appmgr.h>
#include <os.h>
#include <app.h>
#include <frame.h>
#include <menu.h>		// to create menubar
#include <swin.h>		// to create scrolling window
#include <debug.h>
#include <xgesture.h>
#include "pwin.h"
#include "methods.h"

/****************************************************************************/
/*					D E F I N E S   A N D   T Y P E D E F S					*/
/****************************************************************************/

#define clsPaintApp  		MakeGlobalWKN(2238,1)

typedef struct INSTANCE_DATA {

	OBJECT	paintWin;

} INSTANCE_DATA, *P_INSTANCE_DATA;

/****************************************************************************/
/*					F O R W A R D   D E C L A R A T I O N S					*/
/****************************************************************************/

/****************************************************************************/
/*				S T A T I C   D A T A   D E C L A R A T I O N S				*/
/****************************************************************************/

static const TK_TABLE_ENTRY	penMenu[] = {
	{0, 0, 0, 0, 0, clsChoice },
		{ "Standard", msgPaintWinCommand, penStandard },
		{ "MoveDelta", msgPaintWinCommand, penMoveDelta },
		{ "Polling", msgPaintWinCommand, penPoll, 0, tkButtonOn },
		{ pNull },
	{0, 0, 0, 0, 0, clsToggleTable },
		{ "Show Ink", msgPaintWinCommand, penShowInk, 0, tkButtonToggle },
		{ pNull },
	{pNull}
};
static const TK_TABLE_ENTRY	nibMenu[] = {
	{0, 0, 0, 0, 0, clsChoice },
		{ "Round", msgPaintWinCommand, nibRound },
		{ "Square", msgPaintWinCommand, nibSquare },
		{ "Italic", msgPaintWinCommand, nibItalic, 0, tkButtonOn },
		{ pNull },
	{0, 0, 0, 0, 0, clsToggleTable },
		{ "Sampled", msgPaintWinCommand, nibSampled, 0, tkButtonToggle },
		{ pNull },
	{pNull}
};
static const TK_TABLE_ENTRY	colorMenu[] = {
	{0, 0, 0, 0, 0, clsChoice },
		{ "White", msgPaintWinSetColor, (U32)255 },
		{ "Light Gray", msgPaintWinSetColor, (U32)170 },
		{ "Dark Gray", msgPaintWinSetColor, (U32)85 },
		{ "Black", msgPaintWinSetColor, (U32)0, 0, tkButtonOn },
		{ pNull },
	{pNull}
};
static const TK_TABLE_ENTRY	thicknessMenu[] = {
	{0, 0, 0, 0, 0, clsChoice },
		{ "1", msgPaintWinSetThickness, (U32)(1) },
		{ "2", msgPaintWinSetThickness, (U32)(2) },
		{ "3", msgPaintWinSetThickness, (U32)(3), 0, tkButtonOn },
		{ "5", msgPaintWinSetThickness, (U32)(5) },
		{ "8", msgPaintWinSetThickness, (U32)(8) },
		{ "13", msgPaintWinSetThickness, (U32)(13) },
		{ "20", msgPaintWinSetThickness, (U32)(20) },
		{ "35", msgPaintWinSetThickness, (U32)(35) },
		{ "55", msgPaintWinSetThickness, (U32)(55) },
		{ "90", msgPaintWinSetThickness, (U32)(90) },
		{ "150", msgPaintWinSetThickness, (U32)(150) },
		{ "230", msgPaintWinSetThickness, (U32)(230) },
		{ pNull },
	{pNull}
};
static const TK_TABLE_ENTRY menuBarEntries[] = {
	{ "Clear", msgPaintWinClear, 0, 0, tkLabelBold },
	{ "Pen", (U32)penMenu, 0, 0, tkMenuPullDown },
	{ "Nibs", (U32)nibMenu, 0, 0, tkMenuPullDown },
	{ "Ink", (U32)colorMenu, 0, 0, tkMenuPullDown },
	{ "Thickness", (U32)thicknessMenu, 0, 0, tkMenuPullDown },
	{ pNull },
};

/****************************************************************************/
/*			L O C A L   F U N C T I O N S   &   M E T H O D S			    */
/****************************************************************************/

STATIC STATUS CreateMenuBar(
	OBJECT self,
	P_OBJECT pWin)
{
	STATUS		s;
	MENU_NEW	new;

	// create the menu
	ObjCallRet(msgNewDefaults, clsMenu, &new, s);
	new.tkTable.client 	= self;
	new.tkTable.pEntries = menuBarEntries;
	new.menu.style.type 	= msTypeMenuBar;
	ObjCallRet(msgNew, clsMenu, &new, s);
	*pWin = new.object.uid;
	return stsOK;
}

/****************************************************************************
	PaintAppExecuteGesture
	
	Respond to msgAppExecuteGesture.
****************************************************************************/
MsgHandlerArgType(PaintAppExecuteGesture, P_GWIN_GESTURE)
{

	//
	// Paint App does not support Finding, Spelling, or Printing.
	// We do not provide menu buttons for these commands, but the
	// user can still invoke them via gestures on the title line.
	// So, we need to capture the "F", "S", and "P" gestures to
	// prevent the user from invoking their commands.

	switch (pArgs->msg) {

		case xgsFGesture:
		case xgsSGesture:
		case xgsPGesture:

			return stsRequestDenied;

	}

	return ObjectCallAncestor(msg, self, pArgs, ctx);
	MsgHandlerParametersNoWarning;

}	// PaintAppExecuteGesture


/****************************************************************************
	msgPaintWinWildCard
****************************************************************************/
MsgHandlerWithTypes(PaintAppPaintWin, P_ARGS, P_INSTANCE_DATA)
{
	return ObjectCall(msg, pData->paintWin, pArgs);
	MsgHandlerParametersNoWarning;
}

/****************************************************************************
	msgAppInit
****************************************************************************/
MsgHandlerWithTypes(PaintAppAppInit, P_ARGS, P_INSTANCE_DATA)
{
	STATUS			s;
	INSTANCE_DATA	inst;


	//  First pass message to ancestor.
	//
	ObjCallAncestorRet(msg, self, pArgs, ctx, s);

	//  Update/Write instance data.
	//
	memset(&inst, 0, sizeof(inst));
	ObjectWrite(self, ctx, &inst);

	return stsOK;

	MsgHandlerParametersNoWarning;
}

/****************************************************************************
	PaintAppAppOpen

	Respond to msgAppOpen.

	Create objects necessary to make app visible and interact with the user.
****************************************************************************/
MsgHandlerWithTypes(PaintAppAppOpen, P_APP_OPEN, P_INSTANCE_DATA)
{
	STATUS s;
	APP_METRICS am;

	Dbg(Debugf("PaintApp[%p] AppOpen", self);)

	ObjCallRet(msgAppGetMetrics, self, &am, s);

	// create paintWin
	{
	INSTANCE_DATA inst = *pData;
	PAINT_WIN_NEW new;
	WIN_METRICS wm;

	ObjCallRet(msgNewDefaults, clsPaintWin, &new, s);
	new.pixwin.pName = "paintwin.pix";
	new.pixwin.size.w = 400;
	new.pixwin.size.h = 640;
	new.pixwin.planeCount = 2;
	new.pixwin.bCreate = false;
	if (ObjectCall(msgNew, clsPaintWin, &new) < stsOK)
	  {
		ObjCallRet(msgNewDefaults, clsPaintWin, &new, s);
		new.pixwin.pName = "paintwin.pix";
		new.pixwin.size.w = 400;
		new.pixwin.size.h = 640;
		new.pixwin.planeCount = 2;
		new.pixwin.bCreate = true;
		ObjCallRet(msgNew, clsPaintWin, &new, s);
	  }
	inst.paintWin = new.object.uid;
	wm.bounds.size.w = 400;
	wm.bounds.size.h = 640;
	wm.bounds.origin.x = 0;
	wm.bounds.origin.y = 0;
	ObjCallRet(msgWinDelta, inst.paintWin, &wm, s);

	ObjectWrite(self, ctx, &inst);
	}

	/* Create the scroll window */
	{
	SCROLL_WIN_NEW sNew;
	OBJECT innerWin;
	BORDER_STYLE style;

	ObjCallRet(msgNewDefaults, clsScrollWin, &sNew, s);
	sNew.scrollWin.clientWin = pData->paintWin;
	sNew.scrollWin.style.xAlignment = swAlignCenter;
	sNew.scrollWin.style.yAlignment = swAlignCenter;
	ObjCallRet(msgNew, clsScrollWin, &sNew, s);
	ObjCallRet(msgFrameSetClientWin, am.mainWin, (P_ARGS)sNew.object.uid, s);
	ObjCallRet(msgScrollWinGetInnerWin, sNew.object.uid, &innerWin, s);
	ObjCallWarn(msgBorderGetStyle, innerWin, &style);
	style.backgroundInk = bsInkGray33;
	ObjCallWarn(msgBorderSetStyle, innerWin, &style);
	}

	// Insert the menu bar.
	{
	OBJECT menuBar;
	StsWarn(CreateMenuBar(self, &menuBar));
	ObjCallRet(msgFrameSetMenuBar, am.mainWin, (P_ARGS)menuBar, s);
	}

	ObjCallAncestorRet(msg, self, pArgs, ctx, s);
	return stsOK;
	MsgHandlerParametersNoWarning;
} 

/****************************************************************************
	ClsPaintAppInit
	
	Install the PaintApp application.
****************************************************************************/
STATUS EXPORTED ClsPaintAppInit (void)
{
	APP_MGR_NEW		new;
	STATUS			s;

	//
	//  Install the app class clsPaintApp
	//
	ObjCallRet(msgNewDefaults, clsAppMgr, &new, s);
	new.object.uid	 		  	= clsPaintApp;
	new.object.key	 		  	= objWKNKey;
	new.cls.pMsg			  	= PaintAppMethodTable;
	new.cls.ancestor		  	= clsApp;
	new.cls.size			  	= SizeOf(INSTANCE_DATA);
	new.cls.newArgsSize		  	= SizeOf(APP_NEW);
	strcpy(new.appMgr.name, "Paint Demo App");
	strcpy(new.appMgr.company, "GO Corporation");
	strcpy(new.appMgr.version, "1.0");
	strcpy(new.appMgr.defaultDocName, "Paint Demo");
	new.appMgr.copyright		=  \
		"\213 1990-1992 GO Corporation\nAll Rights Reserved.";
	new.appMgr.flags.stationery	= true;
	ObjCallRet(msgNew, clsAppMgr, &new, s);

	return stsOK;
}


/****************************************************************************
	main

	Main application entry point.
		
	Install/register self or install private components and start-up self.
****************************************************************************/
STATUS CDECL main (
	int			argc,  
	char *		argv[],
	U16			processCount)
{
	STATUS	s;
	STATUS ClsPaintWinInit(void);

	Dbg(Debugf("PaintApp processCount[%d]", processCount);)

	if (processCount == 0)
	{
		//  Create application class.
		StsRet(ClsPaintAppInit(), s);
		   
		//  Invoke app monitor to install this application.
		AppMonitorMain(clsPaintApp, objNull);
	}
	else
	{
		// Initialize local well-knowns

		StsRet(ClsPixWinInit(), s);
		StsRet(ClsPaintWinInit(), s);
		   
		//  Create an application instance and dispatch messages.
		AppMain();
	
	}
	Unused(argc);	Unused(argv);
			  
}	/* main */
