/****************************************************************************
 File: milsvc0.h

 (C) Copyright 1992 by GO Corporation, All Rights Reserved.

 You may use this Sample Code any way you please provided you 
 do not resell the code and that this notice (including the above 
 copyright notice) is reproduced on all copies.  THIS SAMPLE CODE 
 IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, AND GO CORPORATION 
 EXPRESSLY DISCLAIMS ALL IMPLIED WARRANTIES, INCLUDING BUT NOT 
 LIMITED TO THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A
 PARTICULAR PURPOSE. IN NO EVENT WILL GO CORPORATION BE LIABLE TO YOU 
 FOR ANY CONSEQUENTIAL,INCIDENTAL,OR INDIRECT DAMAGES ARISING OUT OF 
 THE USE OR INABILITY TO USE THIS SAMPLE CODE.

 $Revision:   1.1  $
   $Author:   jgarrett  $
     $Date:   13 Mar 1992 16:37:18  $

 This file contains the private interface definition for clsTestMILService.
 clsTestMILService is a subclass of clsMILService. 
****************************************************************************/
#ifndef MILSVC0_INCLUDED
#define MILSVC0_INCLUDED

#ifndef GO_INCLUDED
#include <go.h>
#endif

#ifndef MILSVC_INCLUDED
#include <milsvc.h>
#endif


/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 *					Private Parallel Port Class Messages				   *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

/****************************************************************************
 msgTestMILSvcStatus	takes P_NULL, returns STATUS
	starts connection detection.

	We switch to our process context to start connection detection.
	We don't need to do this when connection detection is terminated.

*/

#define msgTestMILSvcDoConnection		MakeMsg(clsTestMILService, 100)


/*
 *	Instance Data
 */

typedef struct INSTANCE_DATA
{
	// Who we are
	OBJECT					self;				// our instance
	U16						logicalId;			// mil device logical id
	U16						unit;				// mil device unit number
	UID						conflictGroup;		// conflict group we're on
	U16						connectStyle;		// is connection detection
												// supported

	// Our state information
	TEST_MIL_SVC_METRICS	testMILSvcMetrics;	// our metrics
	BOOLEAN					open;				// are we open for business
	BOOLEAN					connected;			// are we connected
	BOOLEAN					printInProgress;	// are we in mil printing

	// Request blocks
	P_MIL_REQUEST_BLOCK		pRBMisc;			// used for single stage req.
	P_MIL_REQUEST_BLOCK		pRBPrint;			// used for printing
	P_MIL_REQUEST_BLOCK		pRBConnect;			// used for connection

	// Pointer to ring 0 buffer for printing
	P_U8					printBuffer;
} INSTANCE_DATA, *P_INSTANCE_DATA;

#endif
