/****************************************************************************
 xword.h
 Copyright 1992, GO Corporation, All Rights Reserved

 $Revision:   1.6  $
   $Author:   gmills  $
     $Date:   24 Feb 1992 16:56:06  $

 This file contains the API definition for clsXWord.

 clsXWord inherits from clsXText.

****************************************************************************/
#ifndef XWORD_INCLUDED
#define XWORD_INCLUDED

#ifndef GO_INCLUDED
#include <go.h>
#endif
#ifndef UID_INCLUDED
#include <uid.h>
#endif

/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 *					Common #defines and typedefs						   *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

#define xWordSpellCorrection		flag0
#define xWordSpellOnly				flag1
#define xWordProofEnable			flag2
#define xWordAbbrEnable				flag3


/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 *							Messages									   *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

/****************************************************************************
 msgNewDefaults:               takes P_XLATE_NEW, returns STATUS.
    Fills in default values for a new Word translation object.

 The default values are the same as for clsXText, except for the following
 hwxFlag setting:
	xltSpellingEnable		will be ON
	xltSmartCaseDisable		will be OFF

 In addition, 
//{
	pArgs->xlate.xlateCaseMetrics.type = xcmSentence;
	pArgs->xlate.xlateCaseMetrics.writer = xcmMixedCaseWriter;
//}
 Capitalize first letter of each sentence, etc.
*/


/****************************************************************************
 msgNew:                    takes P_XLATE_NEW, returns STATUS.
    creates a new Word translation object.
*/


/****************************************************************************
 msgXWordComplete:          takes NULL, returns STATUS
    Hook for subclasses to indicate completion.

 Not implemented
*/
#define msgXWordComplete         MakeMsg(clsXWord, 0x81)

#endif
