/****************************************************************************
 File: ichoice.h

 (C) Copyright 1992 by GO Corporation, All Rights Reserved.

 $Revision:   1.3  $
   $Author:   kcatlin  $
     $Date:   16 Mar 1992 08:45:44  $

 This file contains the API for clsIconChoice.

 clsIconChoice inherits from clsChoice.
 IconChoices are exclusive choices with icon buttons and boxed-style
 previewing/on feedback.

 See the documentation for msgTkTableChildDefaults below.
****************************************************************************/

#ifndef ICHOICE_INCLUDED
#define ICHOICE_INCLUDED

												#ifndef CHOICE_INCLUDED
#include <choice.h>
												#endif

												#ifndef ICON_INCLUDED
#include <icon.h>
												#endif

/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 *					Common #defines and typedefs						   *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

typedef OBJECT ICON_CHOICE;

typedef struct ICON_CHOICE_STYLE {
	U16	spare   : 16;  // unused (reserved)
} ICON_CHOICE_STYLE, *P_ICON_CHOICE_STYLE;

/****************************************************************************
 msgNew						takes P_ICON_CHOICE_NEW, returns STATUS
	category: class message
	Creates an iconChoice (and its nested icon windows).
*/

typedef struct ICON_CHOICE_NEW_ONLY {
	ICON_CHOICE_STYLE	style;		// overall style
	ICON_NEW			iconNew;	// storage for default child new struct
	U32					spare;		// unused (reserved)
} ICON_CHOICE_NEW_ONLY, *P_ICON_CHOICE_NEW_ONLY;

#define	iconChoiceNewFields	\
	choiceNewFields			\
	ICON_CHOICE_NEW_ONLY	iconChoice;

typedef struct ICON_CHOICE_NEW {
	iconChoiceNewFields
} ICON_CHOICE_NEW, *P_ICON_CHOICE_NEW;


/****************************************************************************
 msgNewDefaults				takes P_ICON_CHOICE_NEW, returns STATUS
	category: class message
	Initializes the ICON_CHOICE_NEW structure to default values.

 Sets up pArgs->tkTable.pButtonNew to create instances of clsIcon with
 boxed-style previewing/on feedback by default as follows:
//{
	pButtonNew->button.feedback = bsFeedbackBox;
//}
 Zeroes out pNew.iconChoice.
*/


/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 *				    Messages from Other Classes							   *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

/****************************************************************************
 msgTkTableChildDefaults		takes P_UNKNOWN, returns STATUS
	Sets the defaults in P_ARGS for a common child.

 Here is how an iconChoice processes this message:

//{
	if <pArgs->object.class inherits from clsButton> {
		pArgs->button.style.feedback	= bsFeedbackBox;
	}
//}
*/


#endif	// ICHOICE_INCLUDED
