/****************************************************************************
 File: hspkt.h

 (C) Copyright 1992 by GO Corporation, All Rights Reserved.

 $Revision:   1.11  $
   $Author:   kcatlin  $
     $Date:   04 Mar 1992 08:59:18  $

 This file contains the API definition for clsHighSpeedPacket.
 clsHighSpeedPacket inherits from clsService.
 Provides a high speed packet transfer API.
****************************************************************************/

#ifndef HSPKT_INCLUDED
#define HSPKT_INCLUDED

#ifndef GO_INCLUDED
#include <go.h>
#endif

#ifndef MILSERV_INCLUDED
#include <milserv.h>
#endif

#ifndef CLSMGR_INCLUDED
#include <clsmgr.h>
#endif

#ifndef DVHSPKT_INCLUDED
#include <dvhspkt.h>
#endif

/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 *				Common #defines and typedefs							   *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

typedef struct HS_PACKET_METRICS
{
	U16		version;					// version number
	U16		status;						// current status
	U32		asyncBaud;					// baud rate for asynch serial mode
	U16		parConnectChar;				// connect character for connection
										// testing (parallel mode only!)
	U16		parConnectAckChar;			// character to return upon reception
										// of parConnectChar (parallel mode
										// only!)
	U16		leadInChar;					// default lead in character
	U16		dataAckChar;				// default acknowledgement character
										// (return upon reception of 1st data
										// byte or of packet lead in character
										// if one is defined).
	MIL_HS_PACKET_DEVICE_TYPE deviceType;  // device type (see dvhspkt.h)
} HS_PACKET_METRICS, *P_HS_PACKET_METRICS;

typedef OBJECT							HS_PACKET, *P_HS_PACKET;

#define stsHSPacketBusy					MakeStatus(clsHighSpeedPacket, 1)

/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 *					High Speed Packet Class Messages					   *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

/****************************************************************************
 msgHSPacketStatus takes P_HS_PACKET_STATUS, returns STATUS
    Returns the current status of the high speed packet device.
		 
*/

#define msgHSPacketStatus				MakeMsg(clsHighSpeedPacket, 3)

#define hsPktStsBusy					flag0		// status 

typedef struct HS_PACKET_STATUS
{
	U16	status;
} HS_PACKET_STATUS, *P_HS_PACKET_STATUS;

/****************************************************************************
 msgHSPacketSendPacket takes P_HS_PACKET_SEND_PACKET, returns STATUS
	Sends one packet through high speed packet device.
		
 If leadInChar (in metrics) is zero, firstByte is used as lead in 
 character.  If both are zero, no lead in character is sent.
*/

#define msgHSPacketSendPacket				MakeMsg(clsHighSpeedPacket, 9)

typedef struct HS_PACKET_SEND_PACKET
{
	P_UNKNOWN		pBuf;
	U32				numBytes;
	U16				firstByte;
} HS_PACKET_SEND_PACKET, *P_HS_PACKET_SEND_PACKET;

/****************************************************************************
 msgHSPacketSetCharHandler takes P_HS_PACKET_CHAR_HANDLER, returns STATUS
	Installs character receive handler.
    
 HSPacket calls the user-defined function when a character is received.
 The called fucntion must collect the provided character and return either 
 true if the packet is complete, false otherwise.
	 
 userData in HS_PACKET_RX_HANDLER is the user-provided userData U32 in 
 HS_PACKET_CHAR_HANDLER.
 
 If leadInChar (in metrics) is zero, the first character received 
 is contained in both the firstByte and the receivedByte parameters to
 P_HS_PACKET_RX_HANDLER().
		
 The received character handler will not be installed if one already is.
 See msgHSPacketFreeCharHandler.

 The character handler is automatically freed when the service is closed.
*/

#define msgHSPacketSetCharHandler			MakeMsg(clsHighSpeedPacket,10)

typedef BOOLEAN (EXPORTED *P_HS_PACKET_RX_HANDLER)(U16 receivedByte,
												   U16 firstByte,
											       U32 userData);
					 
typedef struct HS_PACKET_CHAR_HANDLER
{
	P_HS_PACKET_RX_HANDLER	pRxHandler;
	U32						userData;
} HS_PACKET_CHAR_HANDLER, *P_HS_PACKET_CHAR_HANDLER;

/****************************************************************************
 msgHSPacketFreeCharHandler takes P_HS_PACKET_CHAR_HANDLER, returns STATUS
	Deinstalls a previously installed character receive handler.

*/

#define msgHSPacketFreeCharHandler			MakeMsg(clsHighSpeedPacket,11)

/****************************************************************************
 msgHSPacketEnable takes nothing, returns STATUS
	Starts the continuous function which tests for connection and make 
	ourselves "visible" to others.

*/

#define msgHSPacketEnable					MakeMsg(clsHighSpeedPacket, 12)

/****************************************************************************
 msgHSPacketDisable takes nothing, returns STATUS
	Stops the continuous function (started by msgHSPacketEnable) 
	which tests for connection and become "invisible".

*/

#define msgHSPacketDisable					MakeMsg(clsHighSpeedPacket, 13)

/****************************************************************************
 msgNew takes P_HS_PACKET_NEW, returns STATUS
	Creates a new hspkt object.

*/

#define hspktNewFields		\
	milServiceNewFields

typedef struct HS_PACKET_NEW {
	hspktNewFields
} HS_PACKET_NEW, *P_HS_PACKET_NEW;


/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 *					Function prototypes									   *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

STATUS EXPORTED ClsHSPacketInit(void);

#endif	// HSPKT_INCLUDED
