/****************************************************************************
 File: flap.h

 (C) Copyright 1992 by GO Corporation, All Rights Reserved.

 $Revision:   1.8  $
   $Author:   kcatlin  $
     $Date:   17 Mar 1992 14:44:26  $

 This file contains the API definition for clsFLAP
 clsFLAP inherits from clsMILService

 This mil service provides the interface between the ALAP mil device
 and the rest of Penpoint.  This interface allows for the configuring
 of the ALAP mil device and for PenTops networking using the ALAP mil
 device.  The flap mil service will typically only be accessed by
 link level drivers since the mil service is responsible for providing
 the lowest levels of the PenTops protocol stack.

 This mil service responds to the messages defined in the link.h header
 file.  Refer to link.h for message definitions.

 You access this mil service by using the standard service access techniques.
 These techniques are discribed in servmgr.h.

 The flap mil service is a member of the 'theLinkHandlers' service manager.
****************************************************************************/
#ifndef FLAP_INCLUDED
#define FLAP_INCLUDED

#ifndef MIL_SERVICE_INCLUDED
#include <milserv.h>
#endif

#ifndef LINK_INCLUDED
#include <link.h>
#endif


/****************************************************************************
 msgNew	takes P_FLAP_NEW, returns STATUS
	creates a new flap object.

*/

#define flapNewFields		\
    milServiceNewFields		\

typedef struct FLAP_NEW {
    flapNewFields
} FLAP_NEW,  *P_FLAP_NEW;


STATUS EXPORTED ClsFLAPInit(void);

#endif
