/*****************************************************************************
* errno.h
* Copyright 1992, GO Corporation, All Rights Reserved
*
*   Error numbers for runtime library
*
* $Revision:   1.7  $
*   $Author:   ctaylor  $
*     $Date:   05 Feb 1992 21:04:40  $
*
*****************************************************************************/
#ifndef _ERRNO_H_INCLUDED

/*
    All errno values in Penpoint are equivalent to the STATUS value
    with the high-bit masked off.  The values are masked because ERRNO
    values are required to be positive.  This header file is included
    when compiling the runtime library and is probably not useful in
    general.
*/

#define errno (*__get_errno_ptr())
extern volatile int errno;

/*
 * Error codes returned by the runtime library
 */

#ifndef GO_INCLUDED
  #include <go.h>
#endif
#ifndef CLSMGR_INCLUDED
  #include <clsmgr.h>
#endif
#ifndef FS_INCLUDED
  #include <fs.h>
#endif
#ifndef GOMATH_INCLUDED
  #include <gomath.h>
#endif

/* Create an errno value from a PenPoint status */
#define StsToErrno(sts) ((int)((U32)(sts)&~flag31))

/* Create a PenPoint status from an errno value */
#define ErrnoToSts(errno)   ((STATUS)((U32)(errno)|flag31))

#define EOK     StsToErrno(stsOK)           /* No error */
#define EINVAL  StsToErrno(stsBadParam)     /* Invalid argument */

#define EBADF   StsToErrno(stsBadObject)    /* Bad file number */
#define ENOSPC  StsToErrno(stsFSVolFull)    /* No space left on device */

/* math errors */
#define EDOM    StsToErrno(stsMathDomain)   /* Argument too large */
#define ERANGE  StsToErrno(stsMathRange)    /* Result too large */

#define _ERRNO_H_INCLUDED
#endif
