/****************************************************************************
 
 File: dyntable.h

 (C) Copyright 1992 by GO Corporation, All Rights Reserved.

 $Revision:   1.46  $
   $Author:   DYEE  $
     $Date:   26 Feb 1992 13:37:44  $

 This file contains the API definition for clsDynamicTableMgr.
 clsDynamicTableMgr inherits from clsObject.

 It allows a tk table to track the comings and goings of installable items.

****************************************************************************/

/**** Overview ****/
/*
 tkTables (see tktable.h) are typically used to display static tables.
 However, there are times when clients wish to build a tkTable that views
 a dynamic structure, such as the installed fonts or the currently
 connected filesystem volumes. clsDynamicTableMgr allows a tk table to
 be dynamically updated as one of these things changes.	Specifically,
 clsDynamicTableMgr supports viewing the contents of an install
 manager (see instlmgr.h) and filesystem volumes (see fs.h).

 When the dynamic table manager is first created it generates a tkTable
 entry for each item in the dynamic structure. The label of the tkTable 
 entry is set to the name of the item. The tkTable entry is tagged with 
 the uid of the Install Manager handle or the uid of a volume's root
 directory handle. 

 If the specified Install Manager is theInstalledFonts and the entry class 
 inherits from clsButton then the short font id is also stored in the 
 entry's data field. 

 clsDynamicTKTableMgr also supports an optional write-in field that is 
 added to the end of the tk table.
*/

#ifndef DYNTABLE_INCLUDED
#define DYNTABLE_INCLUDED

#ifndef CLSMGR_INCLUDED
#include <clsmgr.h>
#endif

#ifndef FONT_INSTALL_INCLUDED
#include <fontmgr.h>
#endif

/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 *					Common #defines and typedefs						   *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

/* Object property tag for entries managed by this class. */
#define	propDTEntry						MakeTag(clsDynamicTableMgr, 1)

/* Tag on the fill-in field button, if style.addFillInField is true. */
#define	tagDTFillInField   				MakeTag(clsDynamicTableMgr, 2)

/* Activated/Deactivated display styles */
#define	dtNoShowDeactivated		    0	// Don't show any deactivated items.
#define	dtShowDeactivated		    1	// Show deactivated items same as 
										// normal items.
#define	dtShowDeactivatedAsInactive	2	// Show deactivated with 
										// bsLookInactive.
typedef struct DYN_TABLE_STYLE {
	U16	showDeactivated : 2,	// How to deal with deactivated elements.
	    autoDestroy		: 1,	// Destroy self when tkTable is freed.
	    ignoreRamVolume	: 1,	// Don't show the RAM filesystem volume.
		putFontIdInData	: 1,	// Put short font id in entry's data field.
		addFillInField  : 1,	// Add a blank write-in field. This is a
								// text field inside of a button.
		unused			: 10;
	U16	spare1;
} DYN_TABLE_STYLE, *P_DYN_TABLE_STYLE;
						 
typedef struct DYN_TABLE_NEW_ONLY {
	DYN_TABLE_STYLE		style;
	OBJECT				installMgr;	  // Install Mgr, ie. theInstalledFonts. 
									  // can also be theFileSystem.
	OBJECT				tkTable;	  // Table to manage. Must be updated 
									  // after msgRestore via 
									  // msgDynTableSetTable.
	CLASS				entryClass;	  // Class of tktable entries.
	P_UNKNOWN			pNewArgs;	  // msgNewDefaulted newArgs for 
									  // entryClass.
	SIZEOF				newArgsSize;  // Size of newArgs.
	FIM_PRUNE_CONTROL	pruneControl; // Prune control if theInstalledFonts.
    U8                  spare[24];
} DYN_TABLE_NEW_ONLY, *P_DYN_TABLE_NEW_ONLY;

#define	dynTableNewFields	\
	objectNewFields 	 	\
	DYN_TABLE_NEW_ONLY	dynTable;

typedef struct DYN_TABLE_NEW {
	dynTableNewFields
} DYN_TABLE_NEW, *P_DYN_TABLE_NEW;

/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 * 				  				  	Messages  		  					   *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

/****************************************************************************
 msgNew							takes P_DYN_TABLE_NEW, returns STATUS
	category: class message
	Creates a new dynamic table manager.
*/


/****************************************************************************
 msgNewDefaults						takes P_DYN_TABLE_NEW, returns STATUS
	category: class message
    Initializes the DYN_TABLE_NEW structure to default values.

 Sets
//{
	dynTable.style.showDeactivated = noShowDeactivated;
	dynTable.style.autoDestroy = true;
	dynTable.style.ignoreRamVolume = true;
	dynTable.style.putFontIdInData = true;
	dynTable.style.addFillInField = false;
//}
*/


/****************************************************************************
 msgDynTableGetTable			    takes P_OBJECT, returns STATUS
	Gets the tkTable we are associated with.
*/
#define msgDynTableGetTable				MakeMsg(clsDynamicTableMgr, 1)


/****************************************************************************
 msgDynTableSetTable			    takes OBJECT, returns STATUS
	Sets our tkTable.

 This must be done whenever this object is restored. It is the client's
 responsiblity to relink the tkTable with the dynamic table manager.
*/
#define msgDynTableSetTable				MakeMsg(clsDynamicTableMgr, 2)


/****************************************************************************
 msgDynTableFindButton		   takes P_DYN_TABLE_FIND_BUTTON, returns STATUS
	Finds a button in the table which has the specified label.

 Return Value
	stsNoMatch:		Label not found.
*/
#define msgDynTableFindButton			MakeMsg(clsDynamicTableMgr, 3)

typedef struct DYN_TABLE_FIND_BUTTON {
	P_STRING			pName;		// Label name of field to find.
	OBJECT				button;		// Out: Found button.
} DYN_TABLE_FIND_BUTTON, *P_DYN_TABLE_FIND_BUTTON;


/****************************************************************************
 msgDynTableSetFillInField		    takes P_STRING, returns STATUS
	Sets the fill-in field to a text string.

 Return Value
	stsBadParam:	There is no fill-in field in the table.
*/
#define msgDynTableSetFillInField		MakeMsg(clsDynamicTableMgr, 4)

#endif // DYNTABLE_INCLUDED

