/****************************************************************************
 dvnmi.h

 Copyright 1992, GO Corporation,   All Rights Reserved

 The public definition of the nmi device interface.

 $Revision:   1.4  $
   $Author:   thall  $
     $Date:   24 Mar 1992 15:09:12  $
****************************************************************************/
#ifndef DVNMI_INCLUDED
#define DVNMI_INCLUDED

/*
 If this device is absent, PenPoint will display a generic fatal error
 message when a non-maskable interrupt (NMI) occurs. If the NMI handler
 function returns an error value in the status field of the request
 block, PenPoint will display an error message. Otherwise, the handler
 can perform any operation that is totally transparent to PenPoint. 
*/

/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 *					Common #defines and typedefs						   *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

/*
 This section contains definitions specific to the nmi device. 
 The definitions contained here are data structures that are necessary
 for the MIL nmi specific functions along with standard
 MIL device data structures with additional fields specific to the
 nmi device.

 
*/

/**** NMI Device Specific Function Numbers ****/

/*
 The following definitions are the device specific functions supported
 by the nmi device. The function numbers start immediately after
 the last function number used by the functions that are common to all
 MIL devices. These function numbers correspond to the Function Transfer
 Table (FTT) entries.

*/
#define milNMIGetDevParameters	milLastCommonFunction+1
#define milNMIHandler			milLastCommonFunction+2

#define fnCountNMI				fnCountBase+2


/**** NMI Device Function Transfer Table ****/
/*
 This structure is the declaration of the NMI Device Function
 Transfer Table. It includes one entry for each of the MIL driver
 functions common to all MIL devices along with one entry for
 each of the device specific functions for the MIL NMI device.
 Each entry contains fields that define the size of the request
 block for that function, the staging requirements of the function,
 and the address of the actual function. 
*/


typedef struct MIL_FTT_NMI {
	funcTransTableCommonFields
	MIL_FUNCTION_DESC functionDesc[fnCountNMI];
} MIL_FTT_NMI, *P_MIL_FTT_NMI;


/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 * 					NMI Device Specific Functions	   	 				   *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

/*
 The following function definitions are the nmi device specific
 functions. Access to these functions is provided by the FTT defined
 above. All of the functions defined below will be passed 3 pointers.

	pCommonData:
		This is a pointer to the common data area.

	pRB:
		This is a pointer to the function request block.

	pDeviceBlock:
		This is a pointer to the device block for the device

 All of the functions return STATUS. Any STATUS other than staging 
 statuses will cause the request to terminate. The staging statuses
 will result in the specified staging operation to be performed.
*/


/****************************************************************************
 milNMIGetDevParameters		returns STATUS
 	Provides device specific information about the nmi device.

 This function is a single stage function that provides device
 specific information about the nmi device.
*/

/**** Device Specific Request Block Fields ****/
/*

 The milNMIGetDevParameters funtion request block contains the
 following fields.
	
	nmiFlags:
		This field is intended to contain bits that describe
		nmi capabilities, modes and status. Currently there
		are no bits defined for this field.

*/

typedef struct MIL_NMI_DEVICE_PARAMETERS {
	U16 nmiFlags;
	U16 reservedU16[2];
	U32 reservedU32[2];
} MIL_NMI_DEVICE_PARAMETERS, *P_MIL_NMI_DEVICE_PARAMETERS;

/*
 rbPublicFieldsNMIGetDevParameters

 This define merges the device specific data structure with the standard
 MIL device parameters reserved fields.

*/

#define rbPublicFieldsNMIGetDevParameters \
	MIL_NMI_DEVICE_PARAMETERS nmiDevParms; \
	U16 funcReservedU16[2]; \
	U32 funcReservedU32[2];
/*
 
 milNMIGetDevParameters Request Block

*/

typedef struct MIL_RB_PUB_NMI_GET_DEV_PARAMETERS {
	milRequestBlockCommonFields
	rbPublicFieldsNMIGetDevParameters
} MIL_RB_PUB_NMI_GET_DEV_PARAMETERS, *P_MIL_RB_PUB_NMI_GET_DEV_PARAMETERS;



/****************************************************************************
 milNMIHandler		returns STATUS
 	Handles the occurance of NMIs.

 Due to the (usually) non-maskable nature of this interrupt the state
 of PenPoint is unknown when this handler is called. Therefor the
 designers of PenPoint machines should only use the non-maskable
 interrupt to indicate catastrophic failures. This function should
 produce some error indication and never return to PenPoint.

*/


/**** Device Specific Request Block Fields ****/
/*

 The milNMIHandler funtion request block does not contain any
 function specific fields.

*/

#define rbPublicFieldsNMIHandler \
	U16 funcReservedU16[2]; \
	U32 funcReservedU32[2];

/*
 
 milNMIHandler Request Block

*/

typedef struct MIL_RB_PUB_NMI_HANDLER {
	milRequestBlockCommonFields
	rbPublicFieldsNMIHandler
} MIL_RB_PUB_NMI_HANDLER, *P_MIL_RB_PUB_NMI_HANDLER;

#endif
