/****************************************************************************

 File: dskview.h

 (C) Copyright 1992 by GO Corporation, All Rights Reserved.

 $Revision:   1.56  $
   $Author:   DYEE  $
     $Date:   26 Feb 1992 13:37:38  $

 This file contains the API definition for clsDiskViewWin.
 clsDiskViewWin inherits from clsCustomLayout.

 It is the view window for a multi-volume disk viewer.

****************************************************************************/

/**** Overview ****/
/*
 The Disk Viewer also defines clsDVBrowBar, clsDVTabButton, clsDVIcon,
 and clsDVForward. These are internal classes which must be well-known
 uids, since the Disk Viewer component is shared.

 The Disk Viewer component implements the heart of the Disk Manager. It
 is consists of two panels: an icon panel and a browser panel. Each known
 filesystem volume (connected and disconnected) is represented by an icon in
 the icon window. Each open volume is represented by a browser card in the 
 browser panel. A browser card is a frame with a menu bar and control tab
 as decoration and an instance of clsBrowser in the view (see browser.h 
 for details).

 The icon panel	is only as big as it needs to be to fit the known volumes.
 The browser panel takes up the rest of the space. The open browser cards
 equally divide up the browser panel.

 Clients will typically put the Disk Viewer component inside of a frame. The
 frame must not be shrink-wrapped; the Disk Viewer must be told what size
 it should be.

 clsDiskViewWin understands the following clsBrowser's messages:

	msgBrowserCreateDir		
	msgBrowserRefresh		
	msgBrowserDelete
	msgBrowserRename		
	msgBrowserGetMetrics	
	msgBrowserWriteState
	msgBrowserReadState		
	msgBrowserSetMetrics	
	msgBrowserSetSelection
	msgBrowserSetThisApp		
	msgBrowserSetClient		
	msgBrowserSelectionPath 
	msgBrowserSelectionUUID
	msgBrowserSelectionDir	
	msgBrowserSelectionName	
	
 The browser messages that deal with the selection are sent to the browser
 which has the current selection. Messages that do not deal with the 
 selection or make sense if there is no selection are sent to all browsers
 in the Disk Viewer.

 The Disk Viewer client is made the client of all the open browsers. The
 client will get all the messages that browsers send to their clients.

 The Disk Viewer takes care of setting up browser state files in a 
 directory off the current working directory. The Disk Viewer ensures that
 the state files for each volume is unique; it handles duplicate volume
 names.

 The Disk Viewer understands msgSave and msgRestore. It will reopen volumes
 that were open when it was saved, and restore as much volume state (which
 directories were expanded) as possible.
*/

#ifndef DSKVIEW_INCLUDED
#define DSKVIEW_INCLUDED

#ifndef CLAYOUT_INCLUDED
#include <clayout.h>
#endif

#ifndef BROWSER_INCLUDED
#include <browser.h>
#endif

/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 * 				  		Common #defines and typedefs  					   *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

/* Illegal volume name error. */
#define stsDVIllegalVolumeName      MakeStatus(clsDiskViewWin, 0)

/* Directory where state files go, relative to theWorkingDir. */
#define	pDVStateDir			        "diskViewState"

/* Trigger point for going over to 'K' size notation */
#define dvKSizeUnit			        1024

/****  Icon Panel Style  ****/
#define	dvShowIcons				0	// Show icons.
#define	dvShowHelpText			1	// Show informative message about each
									// view category.
#define	dvShowClientWin			2	// Client sets contents via 
									// msgDVSetIconPanel.
/****  Icon Style  ****/
#define	dvBigPictTitleUnder		0	// Big icon, title under picture.
#define	dvBigPictTitleRight		1	// Big icon, title to right of picture.
#define	dvSmallPictTitleUnder	2	// Small icon, title under picture.
#define	dvSmallPictTitleRight	3	// Small icon, title to right of picture.

/****  Disk Viewer Style  ****/
typedef struct DV_STYLE {
	U16	displayRamVolume: 1,	// Display the RAM volume. Used for debugging.
								// Disk Viewer app sets this if /DB0800 is on.
		autoOpen		: 1,	// If there is only one volume, open it.
		enableBookshelf	: 1,	// Should bookshelf viewing be enabled?
		enableDirectoryView	: 1,// Should the directory view be enabled?
		showVolumeMenu	: 1,	// Should the volume menu be shown?
		showEditMenu	: 1,	// Should the edit menu be shown?
		showViewMenu	: 1,	// Should the view menu be shown?
		showOptionsMenu	: 1,	// Should the options menu be shown?
		iconPanelStyle	: 3,	// What should be shown in the icon panel?
		iconStyle		: 3,	// Initial icon look, only used if 
								// iconPanelStyle == dvShowIcons.
		unused1			: 2;
	U16	spare1;
	U16	spare2;
} DV_STYLE, *P_DV_STYLE;
						 
/****  Array Element For Volume Name Array  ****/
typedef struct NAME {
	U8			pName[nameBufLength];
} NAME, *P_NAME;

typedef struct DV_NEW_ONLY {
	DV_STYLE    style;
    P_STRING    pBasePath;      // Path offset for each volume;  
					            // pNull for no offset.
    OBJECT      client;	        // Client. Note: client is *not* saved at
					            // msgSave time. Client must restore with
					            // msgBrowserSetClient.
	U16		    numOpenVols;    // Number of volumes to pre-open.
	P_NAME	    pOpenVols;      // Array of volume names.
	TAG		    displayType;    // Default display type for new cards.
	CLASS	    browserClass;   // Class of browser to mutate volume
						        // default browsers to. objNull says
						        // no mutation.
	CLASS	    bookshelfClass; // Class of bookshelf viewer to mutate
						        // volume default bookshelf viewers.
						        // objNull says no mutation.
    U8          spare[24];      // Spare: reserved.
} DV_NEW_ONLY, *P_DV_NEW_ONLY;

#define	diskViewWinNewFields		\
	customLayoutNewFields 			\
	DV_NEW_ONLY		diskViewWin;

typedef struct DV_NEW {
	diskViewWinNewFields
} DV_NEW, *P_DV_NEW;

/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 * 				  				  	Messages  		  					   *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

/****************************************************************************
 msgNew							takes P_DV_NEW, returns STATUS
	category: class message
	Creates a new disk view window.
*/


/****************************************************************************
 msgNewDefaults						takes P_DV_NEW, returns STATUS
	category: class message
    Initializes the DV_NEW structure to default values.

 Zeroes out diskViewWin and sets
//{
	diskViewWin.style.displayRamVolume = false;
	diskViewWin.style.autoOpen = false;
	diskViewWin.style.iconStyle = dvBigPictTitleUnder;
	diskViewWin.style.enableBookshelf = true;
	diskViewWin.style.enableDirectoryView = true;
	diskViewWin.style.showVolumeMenu = true;
	diskViewWin.style.showEditMenu = true;
	diskViewWin.style.showViewMenu = true;
	diskViewWin.style.showOptionsMenu = true;
	diskViewWin.style.iconPanelStyle = dvShowIcons;
	diskViewWin.numOpenVols = 0;
	diskViewWin.displayType = tagDVViewBookshelf;
	diskViewWin.browserClass = objNull;
	diskViewWin.bookshelfClass = objNull;
//}
*/


/****************************************************************************
 msgDVGetStyle				    takes P_DV_STYLE, returns STATUS
	Gets current style setting.
*/
#define msgDVGetStyle						MakeMsg(clsDiskViewWin, 1)


/****************************************************************************
 msgDVSetStyle				    takes P_DV_STYLE, returns STATUS
	Sets style setting.
*/
#define msgDVSetStyle						MakeMsg(clsDiskViewWin, 2)


/****************************************************************************
 msgDVGetBasePath			    takes P_STRING, returns STATUS
	Passes back the current base path. 

 The argument must point to a string buffer that is at least 
 fsPathBufLength in size.
*/
#define msgDVGetBasePath					MakeMsg(clsDiskViewWin, 3)


/****************************************************************************
 msgDVGetIconPanel			    takes P_WIN, returns STATUS
	Passes back the current icon panel window.
*/
#define msgDVGetIconPanel					MakeMsg(clsDiskViewWin, 4)


/****************************************************************************
 msgDVSetIconPanel			    takes P_WIN, returns STATUS
	Sets the icon panel window.

 This message is only relevant if style.iconPanelStyle is set to
 dvShowHelpText or dvShowClientWin.
*/
#define msgDVSetIconPanel					MakeMsg(clsDiskViewWin, 5)


/****************************************************************************
 msgDVGetOpenVols			    takes P_DV_GET_OPEN_VOLS, returns STATUS
	Passes back the names of all the currently open volumes.

 This message allocates a heap block on the process local stack
 (pOpenVols). THE CALLER MUST FREE THIS BLOCK WHEN DONE.

 If there are no open volumes then pOpenVols is set to pNull and
 nothing is allocated.
*/
#define msgDVGetOpenVols					MakeMsg(clsDiskViewWin, 7)

typedef struct DV_GET_OPEN_VOLS {
	U16					numOpenVols; // Number of open volumes.
	P_NAME				pOpenVols;   // Out: Array of volume names. 
									 // must be OSHeapBlockFreed.
    U8                  spare[24];
} DV_GET_OPEN_VOLS, *P_DV_GET_OPEN_VOLS;


/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 *	Private																   *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

/****************************************************************************
 msgDVSetOptionVolume	    takes OBJECT, returns STATUS
	Sets the current volume for our option sheet.
*/
#define msgDVSetOptionVolume				MakeMsg(clsDiskViewWin, 8)


/****************************************************************************
 msgDVCardPopupChanged	    takes BOOLEAN, returns STATUS
	Option card's quick installer popup button has changed.
*/
#define msgDVCardPopupChanged				MakeMsg(clsDiskViewWin, 9)


/****************************************************************************
 msgDVOptionMenuNeed	    takes nothing, returns STATUS
    Sent to the disk view client as notification that the
    option menu is being provided.
*/
#define msgDVOptionMenuNeed				    MakeMsg(clsDiskViewWin, 10)


/****************************************************************************
 msgDVOpenVolume	    takes P_CHAR, returns STATUS
    Opens the disk browser of the volume specified by the given name.
*/
#define msgDVOpenVolume				        MakeMsg(clsDiskViewWin, 11)


/****************************************************************************
 msgDVCloseVolume	    takes P_CHAR, returns STATUS
    Closes the disk browser of the volume specified by the given name.
*/
#define msgDVCloseVolume				    MakeMsg(clsDiskViewWin, 12)

/****************************************************************************
 msgDVConnectToVolume	    takes P_CONNECTIONS_MENU_ITEM, returns STATUS
    Connects a network volume specified in pArgs.
*/
#define msgDVConnectToVolume			    MakeMsg(clsDiskViewWin, 13)

/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 *         	   		 	   	  Menu Messages								   *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */
#define msgDVOpenClose						MakeMsg(clsDVForward, 1)
#define msgDVDuplicate						MakeMsg(clsDVForward, 2)
#define msgDVAddQuickInstall	  			MakeMsg(clsDVForward, 3)
#define msgDVRemoveQuickInstall	  			MakeMsg(clsDVForward, 4)
#define msgDVEjectRemember					MakeMsg(clsDVForward, 5)
#define msgDVEjectForget					MakeMsg(clsDVForward, 6)
#define msgDVFormat							MakeMsg(clsDVForward, 7)

#define msgDVRename							MakeMsg(clsDVForward, 10)

#define msgDVViewAll						MakeMsg(clsDVForward, 20)
#define msgDVViewBookshelf	 				MakeMsg(clsDVForward, 21)
#define msgDVDisplayInstaller				MakeMsg(clsDVForward, 22)

#define msgDVLayoutOptions					MakeMsg(clsDVForward, 30)
#define msgDVDiskOptions					MakeMsg(clsDVForward, 31)

#define msgDVOptionsIcon					MakeMsg(clsDVForward, 41)
#define msgDVOptionsType					MakeMsg(clsDVForward, 42)
#define msgDVOptionsDate					MakeMsg(clsDVForward, 43)
#define msgDVOptionsSize					MakeMsg(clsDVForward, 44)
#define msgDVOptionsDirSize					MakeMsg(clsDVForward, 45)
#define msgDVOptionsVersion					MakeMsg(clsDVForward, 46)
#define msgDVOptionsInstall					MakeMsg(clsDVForward, 47)

#define msgDVSortByName						MakeMsg(clsDVForward, 50)
#define msgDVSortByDate						MakeMsg(clsDVForward, 51)
#define msgDVSortBySize						MakeMsg(clsDVForward, 52)
#define msgDVSortByType						MakeMsg(clsDVForward, 53)

// Note: clsDVForward messages 100 and above are used internally.

/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 *      	      	   			     Tags								   *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */
#define tagDVVolumeMenu						MakeTag(clsDiskViewWin, 1) 
#define tagDVEditMenu						MakeTag(clsDiskViewWin, 2) 
#define tagDVViewMenu						MakeTag(clsDiskViewWin, 3) 
#define tagDVOptionsMenu					MakeTag(clsDiskViewWin, 4)
 
#define tagDVTabButton						MakeTag(clsDiskViewWin, 7) 

#define tagDVOpenClose						MakeTag(clsDiskViewWin, 10) 
#define tagDVDuplicate						MakeTag(clsDiskViewWin, 11) 
#define tagDVEjectRemember					MakeTag(clsDiskViewWin, 12) 
#define tagDVEjectForget				   	MakeTag(clsDiskViewWin, 13) 
#define tagDVRefresh				   		MakeTag(clsDiskViewWin, 14) 
#define tagDVQuickInstall					MakeTag(clsDiskViewWin, 15) 
#define tagDVFormat					   		MakeTag(clsDiskViewWin, 16) 
#define tagDVRename					   		MakeTag(clsDiskViewWin, 17) 
#define tagDVCreateDir				   		MakeTag(clsDiskViewWin, 18) 

#define tagDVViewChoice		 	 		   	MakeTag(clsDiskViewWin, 20) 
#define tagDVViewAll					   	MakeTag(clsDiskViewWin, 21)
#define tagDVViewBookshelf		  		   	MakeTag(clsDiskViewWin, 22)
#define tagDVExpand			 	 		   	MakeTag(clsDiskViewWin, 23) 
#define tagDVCollapse		 	 		   	MakeTag(clsDiskViewWin, 24) 

#define tagDVLayoutOptionMenu 	 		   	MakeTag(clsDiskViewWin, 25) 
#define tagDVDiskOptionMenu 	 		   	MakeTag(clsDiskViewWin, 26) 
 
#define tagDVColumnLayoutOptions 	 		MakeTag(clsDiskViewWin, 30) 
#define tagDVBookshelfLayoutOptions	 		MakeTag(clsDiskViewWin, 31) 
#define tagDVDiskIconOptions	 		   	MakeTag(clsDiskViewWin, 32) 
#define tagDVDiskOptions	 			   	MakeTag(clsDiskViewWin, 33) 

#define tagDVOptionsIcon					MakeTag(clsDiskViewWin, 40) 
#define tagDVOptionsType				   	MakeTag(clsDiskViewWin, 41) 
#define tagDVOptionsSize 					MakeTag(clsDiskViewWin, 42) 
#define tagDVOptionsDirSize 				MakeTag(clsDiskViewWin, 43) 
#define tagDVOptionsDate					MakeTag(clsDiskViewWin, 44) 
#define tagDVOptionsVersion				   	MakeTag(clsDiskViewWin, 45) 
#define tagDVOptionsInstall				   	MakeTag(clsDiskViewWin, 46)
 
#define tagDVSortByChoice			  	   	MakeTag(clsDiskViewWin, 50) 
#define tagDVSortByName					   	MakeTag(clsDiskViewWin, 51) 
#define tagDVSortByDate					   	MakeTag(clsDiskViewWin, 52) 
#define tagDVSortBySize					   	MakeTag(clsDiskViewWin, 53) 
#define tagDVSortByType					   	MakeTag(clsDiskViewWin, 54)

#define tagDVIconCard			   			MakeTag(clsDiskViewWin, 60) 
#define tagDVIconLabel			   			MakeTag(clsDiskViewWin, 61) 
#define tagDVIconChoice			   			MakeTag(clsDiskViewWin, 62) 
#define tagDVIconBigPictTitleUnder 			MakeTag(clsDiskViewWin, 63) 
#define tagDVIconBigPictTitleRight 			MakeTag(clsDiskViewWin, 64) 
#define tagDVIconSmallPictTitleUnder  		MakeTag(clsDiskViewWin, 65) 
#define tagDVIconSmallPictTitleRight  		MakeTag(clsDiskViewWin, 66) 
#define tagDVDefaultBigBitmap		  		MakeTag(clsDiskViewWin, 67) 
#define tagDVDefaultSmallBitmap		  		MakeTag(clsDiskViewWin, 68) 

#define tagDVCardName			   			MakeTag(clsDiskViewWin, 70) 
#define tagDVCardTotal				   		MakeTag(clsDiskViewWin, 71) 
#define tagDVCardFree					   	MakeTag(clsDiskViewWin, 72) 
#define tagDVCardReadOnly				   	MakeTag(clsDiskViewWin, 73) 
#define tagDVCardPopupViewer			   	MakeTag(clsDiskViewWin, 74) 
#define tagDVCardPopupYes				   	MakeTag(clsDiskViewWin, 75) 
#define tagDVCardPopupNo				   	MakeTag(clsDiskViewWin, 76) 
#define tagDVCardInitialView			   	MakeTag(clsDiskViewWin, 77) 
#define tagDVCardInitialPopupChoice		   	MakeTag(clsDiskViewWin, 78) 

#define tagDVBookshelfLayoutLabel		   	MakeTag(clsDiskViewWin, 80) 
#define tagDVBookshelfLayoutChoice		   	MakeTag(clsDiskViewWin, 81) 

#define hlpDVNoVolumesConnected	   		   	MakeTag(clsDiskViewWin, 100) 
#define hlpDVSheetBackground	   		   	MakeTag(clsDiskViewWin, 101) 
#define hlpDVIcon						   	MakeTag(clsDiskViewWin, 102) 
#define hlpDVIconBackground				   	MakeTag(clsDiskViewWin, 103) 
#define hlpDVTabButton					   	MakeTag(clsDiskViewWin, 104)
 
#define hlpDVVolumeMenu						MakeTag(clsDiskViewWin, 110) 
#define hlpDVEditMenu						MakeTag(clsDiskViewWin, 111) 
#define hlpDVViewMenu						MakeTag(clsDiskViewWin, 112) 
#define hlpDVOptionsMenu	   				MakeTag(clsDiskViewWin, 113) 

#define hlpDVClose							MakeTag(clsDiskViewWin, 120) 
#define hlpDVDuplicate 						MakeTag(clsDiskViewWin, 121) 
#define hlpDVEjectRemember 					MakeTag(clsDiskViewWin, 122) 
#define hlpDVEjectForget 					MakeTag(clsDiskViewWin, 123) 
#define hlpDVRefresh 						MakeTag(clsDiskViewWin, 124)
#define hlpDVQuickInstall					MakeTag(clsDiskViewWin, 125) 
#define hlpDVFormat							MakeTag(clsDiskViewWin, 126)
 
#define hlpDVMove							MakeTag(clsDiskViewWin, 130) 
#define hlpDVCopy							MakeTag(clsDiskViewWin, 131) 
#define hlpDVDelete							MakeTag(clsDiskViewWin, 132) 
#define hlpDVRename							MakeTag(clsDiskViewWin, 133) 
#define hlpDVCreateDir 						MakeTag(clsDiskViewWin, 134)
 
#define hlpDVViewAll 					   	MakeTag(clsDiskViewWin, 140) 
#define hlpDVViewBookshelf    				MakeTag(clsDiskViewWin, 141) 
#define hlpDVDisplayInstaller		      	MakeTag(clsDiskViewWin, 142) 
#define hlpDVExpand							MakeTag(clsDiskViewWin, 143) 
#define hlpDVCollapse 						MakeTag(clsDiskViewWin, 144)

#define hlpDVLayoutOptionMenu				MakeTag(clsDiskViewWin, 145)
#define hlpDVDiskOptionMenu					MakeTag(clsDiskViewWin, 146)
 
#define hlpDVDiskOptions					tagDVDiskOptions
#define hlpDVDiskIconOptions	  			tagDVDiskIconOptions
#define hlpDVColumnLayoutOptions	  		tagDVColumnLayoutOptions
#define hlpDVBookshelfLayoutOptions	        tagDVBookshelfLayoutOptions

#define hlpDVOptionsColumnsLabel            MakeTag(clsDiskViewWin, 150)

#define hlpDVOptionsIcon 					MakeTag(clsDiskViewWin, 160) 
#define hlpDVOptionsType 					MakeTag(clsDiskViewWin, 161) 
#define hlpDVOptionsDate 					MakeTag(clsDiskViewWin, 162) 
#define hlpDVOptionsSize	 				MakeTag(clsDiskViewWin, 163) 
#define hlpDVOptionsDirSize 				MakeTag(clsDiskViewWin, 164) 
#define hlpDVOptionsVersion 				MakeTag(clsDiskViewWin, 165) 
#define hlpDVOptionsInstall	 				MakeTag(clsDiskViewWin, 166) 

#define hlpDVSortByChoice					MakeTag(clsDiskViewWin, 170) 
#define hlpDVSortByName						MakeTag(clsDiskViewWin, 171) 
#define hlpDVSortByDate						MakeTag(clsDiskViewWin, 172) 
#define hlpDVSortBySize						MakeTag(clsDiskViewWin, 173) 
#define hlpDVSortByType						MakeTag(clsDiskViewWin, 174)
 
#define hlpDVDiskCardName					MakeTag(clsDiskViewWin, 180) 
#define hlpDVDiskCardTotalSpace				MakeTag(clsDiskViewWin, 181) 
#define hlpDVDiskCardFreeSpace				MakeTag(clsDiskViewWin, 182) 
#define hlpDVDiskCardReadOnly				MakeTag(clsDiskViewWin, 183) 
#define hlpDVDiskCardQuickInstaller			MakeTag(clsDiskViewWin, 184) 
#define hlpDVDiskCardInitialView			MakeTag(clsDiskViewWin, 185)
 
#define hlpDVIconCardStyle					MakeTag(clsDiskViewWin, 190) 

// QH tags for the column headers in diskview

#define hlpDVNameColumn                     MakeTag(clsDiskViewWin, 191)
#define hlpDVTypeColumn                     MakeTag(clsDiskViewWin, 192)
#define hlpDVDateColumn                     MakeTag(clsDiskViewWin, 193)
#define hlpDVTimeColumn                     MakeTag(clsDiskViewWin, 194)
#define hlpDVSizeColumn                     MakeTag(clsDiskViewWin, 195)
#define hlpDVVersionColumn                  MakeTag(clsDiskViewWin, 196)
#define hlpDVInstallColumn                  MakeTag(clsDiskViewWin, 197)

#endif // DSKVIEW_INCLUDED			

