/****************************************************************************
 File: closebox.h

 (C) Copyright 1992 by GO Corporation, All Rights Reserved.

 $Revision:   1.42  $
   $Author:   kcatlin  $
     $Date:   17 Mar 1992 14:39:06  $

 This file contains the API definition for clsCloseBox.

 clsCloseBox inherits from clsMenuButton.
 Close boxes are frame decorations that let you close the frame.
 Close boxes paint as a triangle in the upper-left hand corner.
****************************************************************************/
#ifndef CLOSEBOX_INCLUDED
#define CLOSEBOX_INCLUDED

													#ifndef MBUTTON_INCLUDED
#include <mbutton.h>
													#endif

/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 *					Common #defines and typedefs						   *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

#define hlpCloseBoxGeneral	  	MakeTag(clsCloseBox, 1)

typedef OBJECT CLOSE_BOX;

typedef struct CLOSE_BOX_STYLE {
	U16 spare		: 16;	// unused (reserved)
} CLOSE_BOX_STYLE, *P_CLOSE_BOX_STYLE;


/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 *							Messages									   *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

/****************************************************************************
 msgNew		takes P_CLOSE_BOX_NEW, returns STATUS
	category: class message
	Creates a closebox window.

*/

typedef struct CLOSE_BOX_NEW_ONLY {
	CLOSE_BOX_STYLE	style;
	U32				spare;	// unused (reserved)
} CLOSE_BOX_NEW_ONLY, *P_CLOSE_BOX_NEW_ONLY;

#define	closeBoxNewFields	\
	menuButtonNewFields			\
	CLOSE_BOX_NEW_ONLY		closeBox;

typedef struct CLOSE_BOX_NEW {
	closeBoxNewFields
} CLOSE_BOX_NEW, *P_CLOSE_BOX_NEW;

/****************************************************************************
 msgNewDefaults				takes P_CLOSE_BOX_NEW, returns STATUS
	category: class message
	Initializes the CLOSE_BOX_NEW structure to default values.

 Zeroes out pArgs->closeBox and sets
//{
	pArgs->win.flags.style &= ~(U32)(wsShrinkWrapWidth | wsShrinkWrapHeight);

	pArgs->gWin.style.gestureEnable = false;
	pArgs->gWin.helpId = hlpCloseBoxGeneral;

	pArgs->border.style.edge = bsEdgeBottom;
	pArgs->border.style.shadow = bsShadowNone;
	pArgs->border.style.join = bsJoinSquare;
	pArgs->border.style.leftMargin = bsMarginNone;
	pArgs->border.style.rightMargin = bsMarginNone;
	pArgs->border.style.bottomMargin = bsMarginNone;
	pArgs->border.style.topMargin = bsMarginNone;

	pArgs->button.style.feedback = bsFeedbackNone;
//}
*/

/****************************************************************************
 msgCloseBoxGetStyle		takes P_CLOSE_BOX_STYLE, returns STATUS
	Passes back the current style values.

*/
#define msgCloseBoxGetStyle	  	MakeMsg(clsCloseBox, 1)

/****************************************************************************
 msgCloseBoxSetStyle		takes P_CLOSE_BOX_STYLE, returns STATUS
	Sets the style values.

*/
#define msgCloseBoxSetStyle	  	MakeMsg(clsCloseBox, 2)

#endif	// CLOSEBOX_INCLUDED
