/****************************************************************************
 File: battery.h

 (C) Copyright 1992 by GO Corporation, All Rights Reserved.

 $Revision:   1.8  $
   $Author:   esoloko  $
     $Date:   19 Feb 1992 21:21:24  $

 This file contains the API definition for clsMILPowerDevice.
 clsMILPowerDevice inherits from clsService.

 theBattery is a well-known instance of clsMILPowerDevice.
 theBattery provides access to the primary battery of the computer.

 theBatteries is a well-known instance of clsServiceManager.
 theBatteries is the service manager that manages the instances of
 clsMILPowerDevice that represent the computer's batteries
 (including theBattery).

 clsMILPowerDevice provides an object interface to the computer's
 power devices (i.e. batteries).

****************************************************************************/
#ifndef BATTERY_INCLUDED
#define BATTERY_INCLUDED

#ifndef MILSERV_INCLUDED
#include <milserv.h>
#endif

/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 *  						Types and Constants							   *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

// battery flags
#define milRawVoltsSupported             flag0
#define milPercentLeftSupported          flag1
#define milSecondsLeftSupported          flag2
#define milSetLevelSupported             flag3

/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 *                                  Messages                               *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

/****************************************************************************
 msgBatteryGetMetrics					takes P_BATTERY_METRICS, returns STATUS
	Passes back the battery's metrics.
*/
#define msgBatteryGetMetrics				MakeMsg(clsMILPowerDevice, 1)

typedef struct BATTERY_METRICS {

	U16 batteryFlags;					// flags defined above
	U16 maxMillivolts;
	U16 warnMillivolts;
	U16 failMillivolts;
	U16 currentMillivolts;
	U16 percentOfBatteryLeft;
	U16 maxSeconds;
	U16 secondsOfBatteryLeft;

} BATTERY_METRICS, * P_BATTERY_METRICS;

/****************************************************************************
 msgBatterySetLevel					takes U16, returns STATUS
	Sets the percentage of battery remaining.

 The MIL request milPowerSetBatteryLevel is sent to the MIL device unit
 represented by the receiver.
*/
#define msgBatterySetLevel				MakeMsg(clsMILPowerDevice, 2)

/****************************************************************************
 msgBatteryLow						takes void, returns STATUS
	category: observer notification
	Sent when a battery level is dangerously low.
*/
#define msgBatteryLow				MakeMsg(clsMILPowerDevice, 128)

/****************************************************************************
 msgBatteryCritical					takes void, returns STATUS
	category: observer notification
	Sent when a battery drops level below the shutdown level.
*/
#define msgBatteryCritical			MakeMsg(clsMILPowerDevice, 129)

#endif
