/****************************************************************************
 acetate.h

 Copyright 1992, GO Corporation, All Rights Reserved

 $Revision:   1.8  $
   $Author:   kcatlin  $
	 $Date:   17 Mar 1992 14:36:00  $

 Interface file for the acetate.

 The functions described in this file are contained in INPUT.LIB.

 WARNING:	Inking and the acetate layer are subject to major changes in
 future releases.

****************************************************************************/
#ifndef ACETATE_INCLUDED
#define ACETATE_INCLUDED

#ifndef GO_INCLUDED
#include <go.h>
#endif

#ifndef GEO_INCLUDED
#include <geo.h>
#endif

//prototypes
/****************************************************************************
 AcetateTransform	returns void
	Converts coordinate to/from screen device root window and pen units.

 Warning: This works only when transforming to or from the screen device
 root window.  Other transforms must use drawing contexts.
*/
void EXPORTED AcetateTransform(
	P_XY32 pXY,			// coordinates to transform
	U16 type			// 0 for root-to-pen 
						// 1 for pen-to-root
	);


/****************************************************************************
 AcetateCursorRequestVisible	returns void
	Used to request that the cursor turn on or off.
*/
void EXPORTED AcetateCursorRequestVisible(
	BOOLEAN	requestVisibleOn
	);

/****************************************************************************
 AcetateCursorThaw	returns STATUS
	Unfreezes the cursor for pen movements.
*/
STATUS EXPORTED AcetateCursorThaw(
	void
	);

/****************************************************************************
 AcetateCursorFreezePosition	returns STATUS
	Freezes the cursor at the given Root window coordinate until the
	cursor image is reset to pNull (standard cursor).
*/
STATUS EXPORTED AcetateCursorFreezePosition(
	P_XY32 pLoc			// location in the root window
	);

/****************************************************************************
 AcetateCursorXY	returns void
	Sets the cursor position.
*/
void EXPORTED AcetateCursorXY(
	COORD32 x,
	COORD32 y
	);

/****************************************************************************
 AcetateCursorImage		returns STATUS
	Sets the cursor image.

 If pCursor == pNull, resets to the pen cursor and frees the substitute
 cursor memory.
*/
STATUS EXPORTED AcetateCursorImage(
	P_UNKNOWN pNewCursor,
	BOOLEAN sticky
	);

/****************************************************************************
 AcetateCursorUpdateImage		returns STATUS
	Updates the current cursor image.

 This interface should only be used for cursor animations and not to change
 the actual cursor to a different style.
*/
STATUS EXPORTED AcetateCursorUpdateImage(
	P_UNKNOWN pNewCursor
	);

/****************************************************************************
 AcetateClear	returns void
	Clears (makes transparent) the entire acetate plane.
*/
void EXPORTED AcetateClear(
	void
	);

/****************************************************************************
 AcetateClearDisable	returns void
	Used while grabbing to keep the acetate from being cleared.

 Call it during input event processing and return one of the grab status
 return values.  While the Clear Disable is active, calls to AcetateClear
 will have no effect.  Calls to AcetateClearRect will still work however.
*/
void EXPORTED AcetateClearDisable(
	void
	);


/****************************************************************************
 AcetateClearRect	returns void
	Clears (makes transparent) the indicated acetate rect. pNull implies
	the entire plane.
*/
void EXPORTED AcetateClearRect(
	P_RECT32 pRect
	);

#endif
