; module USEN2.ASM  - for redirecting list output to SEN:
; Copyright 1984, Decmation, Inc., Santa Clara, CA 95051
;
; This module may be inserted between CP/M and the Decmation
; Bios to change terminal or printer characteristics
; All calls to the bios pass through here
;
; In order to use this a 63K cp/m can be created:
; A>MOVCPM 63 *
; A>SAVE 34 CPM63.COM
; A>DDT CPM63.COM
; -IUSEN1.HEX
; -R
; -IUSEN2.HEX
; -R2980
; -G0
; A>SAVE 37 USEN.COM
; A>USEN (COMMAND LINE)  (command line executes with list to SEN:)
; **** TERMINAL KEY ASSIGNMENTS ****
;
; PF1- INSERT/OVERWRITE (CTRL-V)
; PF2- NEXT RECORD (CTRL-C)
; PF3- EXIT/SAVE (CTRL-W)
; PF4- EXIT/NOSAVE (CTRL-Q)
; UPARROW - CURSOR UP (CTRL-E)
; DOWNARROW - CURSOR DOWN (CTRL-X)
; LEFTARROW - CURSOR LEFT (CTRL-S)
; RIGHTARROW -CURSOR RIGHT (CTRL-D)
; BACKSPACE - DELETE CHAR TO LEFT (RUBOUT)
; DELETE - DELETE CHAR AT CURSOR (CTRL-G)
;
;
	org	0f600h	;start of bios for 63k CP/M
x	equ	0400h	;1024 byte offset
	jmp	$+x
wboot	equ	$+x
	jmp	wbootx	;warm boot call
contst	equ	$+x	;bios address for console ready check
	jmp	contsx	;console char ready check
			;returns A =ff for ready, 00 for not
conin	equ	$+x
	jmp	coninx	;get console char in A
conout	equ	$+x
	jmp	conoux	;console char out, sends C to console
list	equ	$+x
	jmp	listx	;list char out, sends C to list device
	jmp	$+x	;punch char out (C)
	jmp	$+x	;get reader char (A) (1AH=eof)
	jmp	$+x	;home (set disk track to 0)
	jmp	$+x	;seldsk (set current disk to value of C)
	jmp	$+x	;settrk BC contains track number
	jmp	$+x	;setsec BC contains disk sectory number
	jmp	$+x	;setdma BC contains DMA address for disk
	jmp	$+x	;read read 1 sector, return A=1 error, =0 
			;no error
	jmp	$+x	;write sector, A returned =1 error, =0
			;no error
lstst	equ	$+x
	jmp	lstsx	;listst test list ready A=0 not ready, ff
			;ready
	jmp	$+x	;sectran sector in in BC, out in HL
			;table in DE
	jmp	$+x
	jmp	$+x
	jmp	$+x
	jmp	$+x
	jmp	$+x
	jmp	$+x
	jmp	$+x
	jmp	$+x
	jmp	$+x
	jmp	$+x
	jmp	$+x
	jmp	$+x
;
; switches to modify action, may be patched
	org	0f680h
swt1:	db	0	;set to ff to use time delay on escape detection
swt2:	db	0ffh	;set to ff to redirect list output to SEN: device
swt3:	db	0ffh	;enable redirection of console to list on ctrl-p
swt4:	db	'P' and 31	;ctrl-P (may change to other)
swt5:	db	'z' and 31	;char to close sen device if swt6
swt6:	db	0ffh	;set true to close sen on warm boot
;
;
; time delay routine, use to distingush escape sequence from escape
;
wait:	push	h
	push	psw
	mvi	h,090h	;9*4k=48k counts about .1 sec
	mvi	l,0
wait1:	dcx	h
	mov	a,h
	ora	l
	jnz	wait1	;loop
	pop	psw
	pop	h
	ret
;
; process request for console input
;
esc	equ	27	;define escape char
;
coninx:	lda	buf	;address subject to modification
sptr	equ	$-2	;point to saved string to be passed
	ora	a
	jz	cinx2	;if nothing waiting
	lhld	sptr	;get pointer
	inx	h
	shld	sptr	;stepped one byte
	ret		;return with char in A
cinx2:	call	conin	;get the next char from keyboard
	lxi	h,swt4	;points to ctrl-p or?
	cmp	m	;is this ctrl-P
	jnz	cinx22	;skip if not
	push	psw	;save a
	lda	swt3
	ora	a
	jz	cinx21	;not enabled
	pop	psw	;toss char
	mvi	c,7	;send first beep
	call	conout
	lda	prtflg
	ora	a
	jz	cinx25	;not enabled
; here already enabled, disable, send second beep
	xra	a
	sta	prtflg
	mvi	c,7
	call	conout
	jmp	cinx2	;go get another char
cinx25:	mvi	a,0ffh
	sta	prtflg	;enable
	jmp	cinx2	;go get next char
cinx21:	pop	psw	;restore char read
cinx22:
; test for char typed to close sen
	lxi	h,swt5
	cmp	m
	jnz	cinx2a
	ora	a
	jz	cinx2a	;zero illegal char
	call	eofsen	;do eof
	jmp	cinx2	;get another char
cinx2a:
	ret	;inserted to null out rest of following code
;place for possible output string
;
buf:	db	0,0,0,0,0,0,0,0,0,0,0,0,0	;must term with 0
;
;
; call to test console ready
contsx:	lhld	sptr	;see if saved chars waiting
	mov	a,m
	ora	a
	jnz	conts2	;some chars wait locally
	jmp	contst	;relay the call
conts2:	mvi	a,0ffh
	ret
;
; come there for console out, test for initialization string
prtflg:	db	0	;wen nonzero CON: output goes to list too
; following instruction subject to modification by pgm
conoux:	lda	oubuf	;see if any waiting
	ora	a
	jnz	conou4	;clean up waiting message
conou2:	lda	prtflg	;see if printer echo
	ora	a
	jz	conou3
;echo
	push	b	;save c
	call	listx
	pop	b
conou3:	call	conout	;call bios
	ret
; else send a waiting char and restart
conou4:	push	b	;save the current
	mov	c,a	;saved one
	call	conou2	;send it
	lhld	conoux+1
	inx	h
	shld	conoux+1
	pop	b
	jmp	conoux	;repeat till all send (zero detected)
;
oubuf:	db	0,0,0,0,0,0,0,0,0,0
;
; come here on warm boot request, send console termination string
;
wbootx:	lda	finbuf
	ora	a
	jnz	wboot1	;if finishing string for terminal
;close sen device if need be
	lda	swt6
	ora	a
	jz	wboot	;if zero go do wboot
	call	eofsen	;end file sen
	jmp	wboot	;no do wboot
wboot1:	mov	c,a
	call	conout	;send a char
	lhld	wbootx+1
	inx	h
	shld	wbootx+1
	jmp	wbootx	;send another
;
finbuf:	db	0,0,0,0,0,0,0,0,0,0
;
; code to redirect list output to SEN: device
;
listx:	lda	swt2	;do only if this nonzero
	ora	a
	jnz	listb
	jmp	list	;relay call
listb:	MOV	A,C	;CHECK FOR CTRL-Z
	CPI	26
	JNZ	LISTBB
	CALL	EOFSEN
	RET
LISTBB:	lhld	lstptr
	mov	m,c	;put char in buffer
	inx	h
	shld	lstptr	;pointer away
	lda	lstcnt
	dcr	a
	sta	lstcnt	;count stepped
	sta	senflg	;sen device opened flag
	rnz		;done if count not exhausted
	dcr	a
	sta	senflg	;keep sen flag non zero
; buffer full, send 128 byte sector
savdsk	equ	0fa42h	;bios calls
sensec	equ	0fa3ch	;send 128 byte sector to SEN:
seneof	equ	0fa3fh	;end file SEN:
setdma	equ	0fa24h	;also used by SEN:
;
senbuf:	call	savdsk	;save current dma address
	inx	h
	inx	h
	inx	h
	inx	h	;point to dma word
	mov	c,m	;get word in bc
	inx	h
	mov	b,m
	push	b	;save for restore later
	lxi	b,lstbuf	;send from buffer
	call	setdma	;set address as if disk
	call	sensec	;send 128 bytes
	pop	b	;restore
	call	setdma
; now zero the buffer for more data
zbuf:	mvi	c,64	;count
	lxi	h,lstbuf
	mvi	a,0
lst3:	mov	m,a	;zero loc
	inx	h
	mov	m,a	;zero next
	inx	h
	dcr	c	;dec count
	jnz	lst3	;loop 64 times to zero 128
; reset ptrs
	mvi	a,128
	sta	lstcnt
	lxi	h,lstbuf
	shld	lstptr
	ret
;
lstptr:	dw	lstbuf
lstcnt	db	128
;
lstbuf:	dw	0,0,0,0,0,0,0,0
	dw	0,0,0,0,0,0,0,0
	dw	0,0,0,0,0,0,0,0
	dw	0,0,0,0,0,0,0,0
	dw	0,0,0,0,0,0,0,0
	dw	0,0,0,0,0,0,0,0
	dw	0,0,0,0,0,0,0,0
	dw	0,0,0,0,0,0,0,0
;
; this flag set non-zero when sen device open
; cleared when closed
senflg:	db	0
;
; routine to end file on sen device
;
eofsen:	lda	swt2
	ora	a
	rz	;if sen disabled
	lda	senflg
	ora	a
	rz	;if never opened
	lda	lstcnt
	cpi	128	;if empty buffer
	jz	eof1	;dont send
	call	senbuf	;send this last buffer of data
	jmp	eof2
eof1:	call	zbuf	;zero buffer if not sending buffer
eof2:	xra	a
	sta	senflg
	call	seneof
	ret
; routine to test list ready
lstsx:	lda	swt2
	ora	a
	jz	lstst	;if sen disabled, relay call
	mvi	a,0ffh	;otherwise always ready
	ret
et

s ready
	ret

et

se always ready
	ret

et

ise always ready
	ret

et

se alwa