; module MP2.ASM  - for using VT100 with multiplan
; Copyright 1983, Decmation, Inc., Santa Clara, CA 95051
;
; This module may be inserted between CP/M and the Decmation
; Bios to change terminal or printer characteristics
; All calls to the bios pass through here
;
; In order to use this a 63K cp/m can be created:
; A>MOVCPM 63 *
; A>SAVE 34 CPM63.COM
; A>DDT CPM63.COM
; -IMP1.HEX
; -R
; -IMP2.HEX
; -R2980
; -G0
; A>SAVE 37 RMP.COM
; A>RMP	(RUNS MULTIPLAN WITH MODIFIED KEY ASSIGNMENTS ON VT100)
;
; **** TERMINAL KEY ASSIGNMENTS ****
;
; PF1- SAME AS CTL-C (CANCEL)
; PF2- SAME AS CTL-W (NEXT WINDOW)
; PF3- SAME AS CTL-Q (HOME)
; PF4- SAVE AS CTL-Z (END)
; UPARROW - CURSOR UP (CTRL-E)
; DOWNARROW - CURSOR DOWN (CTRL-X)
; LEFTARROW - CURSOR LEFT (CTRL-S)
; RIGHTARROW -CURSOR RIGHT (CTRL-D)
; CTL-B SAME AS CTL-O (WORD LEFT)
; CTL-N SAME AS CTL-P (WORD RIGHT)
; LF OR CTL-J - SAME AS CTL-F (NEXT UNLOCKED CELL)
	org	0f600h	;start of bios for 63k CP/M
x	equ	0400h	;1024 byte offset
	jmp	$+x
wboot	equ	$+x
	jmp	wboot	;warm boot call
contst	equ	$+x	;bios address for console ready check
	jmp	contst	;console char ready check
			;returns A =ff for ready, 00 for not
conin	equ	$+x
	jmp	coninx	;get console char in A
conout	equ	$+x
	jmp	conout	;console char out, sends C to console
list	equ	$+x
	jmp	list	;list char out, sends C to list device
	jmp	$+x	;punch char out (C)
	jmp	$+x	;get reader char (A) (1AH=eof)
	jmp	$+x	;home (set disk track to 0)
	jmp	$+x	;seldsk (set current disk to value of C)
	jmp	$+x	;settrk BC contains track number
	jmp	$+x	;setsec BC contains disk sectory number
	jmp	$+x	;setdma BC contains DMA address for disk
	jmp	$+x	;read read 1 sector, return A=1 error, =0 
			;no error
	jmp	$+x	;write sector, A returned =1 error, =0
			;no error
lstst	equ	$+x
	jmp	lstst	;listst test list ready A=0 not ready, ff
			;ready
	jmp	$+x	;sectran sector in in BC, out in HL
			;table in DE
	jmp	$+x
	jmp	$+x
	jmp	$+x
	jmp	$+x
	jmp	$+x
	jmp	$+x
	jmp	$+x
	jmp	$+x
	jmp	$+x
	jmp	$+x
	jmp	$+x
	jmp	$+x
;
;
; process request for console input
;
esc	equ	27	;define escape char
;
coninx:	call	conin	;get a keyboard character in A
	cpi	esc	; see if escape char
	jnz	t2	;skip escape sequence analysis if not
	call	conin	;the next char in sequence
	cpi	'['	;bracket ignore
	jz	t12
	cpi	'O'	;ignore O too
	jz	t12
	cpi	'?'	; ? too
	jz	t12
	jmp	t13	;if not ignore process as significent char
t12:	call	conin	;get 3rd char of escape sequence
t13:	cpi	'A'	;process the significent char
	jnz	t131
	mvi	a,'e' and 31	;change to ctl-E up arrow
	ret
t131:	cpi	'B'
	jnz	t132
	mvi	a,'x' and 31	;down arrow
	ret
t132:	cpi	'C'
	jnz	t133
	mvi	a,'d' and 31	;right arrow
	ret
t133:	cpi	'D'
	jnz	t134
	mvi	a,'s' and 31	;left arrow
	ret
t134:	cpi	'P'	;pf1 key
	jnz	t135
	mvi	a,'c' and 31	;becomes ctl-c
	ret
t135:	cpi	'Q'	;pf2
	jnz	t136
	mvi	a,'w' and 31
	ret
t136:	cpi	'R'	;pf3
	jnz	t137
	mvi	a,'q' and 31
	ret
t137:	cpi	'S'	;pf4
	jnz	t138
	mvi	a,'z' and 31
; return it, not part of legal escape seq
t138:	ret
; process non escape sequences
t2:	cpi	'n' and 31	;ctl-m becomes
	jnz	t21
	mvi	a,'p' and 31	;ctl-p
	ret
t21:	cpi	'b' and 31	;ctl-n becomes
	jnz	t22	;pass if not tested for
	mvi	a,'o' and 31	;ctl-O
	ret
t22:	cpi	'j' and 31	;line feed becomes ctl-F
	jnz	t23
	mvi	a,'f' and 31
	ret
t23:	ret
 
 v `)@