                                                    zeus(n)

zeus
    zeus - Zeus control panel description

DESCRIPTION
    M3zume takes a relatively terse specification of events for a Zeus
    animation and produces from it the Modula-3 .i3 and .i3 files
    that define the Zeus-mediated communication between the algorithm and
    the views.  The event specification is a file named <basename>.evt.

    M3zume reads the event file and combines it with template files
    (stored in the m3zume package) to produce derived files

            <basename>AlgClass.{i3,m3}, 
            <basename>ViewClas.{i3,m3},
            <basename>IE.{i3,m3},
            <basename>TranscriptView.{i3,m3}, and
            <basename>EventData.fv.  

    For testing purposes, the template file directory may be overridden
    using the -testdir command-line option.

    If Baz() is an event procedure defined in Foo.evt, then FooIE.Baz
    is called to signal the occurrence of the event.

FILE FORMAT
    
    The main part of the event file is a list of slightly modified
    Modula-3 headers for the procedures that the algorithm will call
    to generate events.  Before any of these procedure headers, the
    .evt file contains the IMPORT statements necessary to define the
    procedure arguments, followed by a section introduced by the keyword
    ALGDATA that contains the data fields that should belong to a
    <basename>AlgClass.T.
    
    The procedure headers use keywords OUTPUT and FEEDBACK in lieu
    of PROCEDURE. Output events (PROCEDURE may also be used instead of
    OUTPUT) are delivered to views; they are typically generated by
    an algorithm. Feedback events are delivered to the algorithm;
    they are typically generated by a view.
    
    Each event has an integer priority in the range 1-9, which Zeus
    uses to decide whether to pause after the event while
    single-stepping (1 means it's always OK to pause).  To specify a
    priority, append the appropriate integer to the OUTPUT, FEEDBACK,
    or PROCEDURE keyword.  Omitting the priority is the same as
    specifying priority 1.
    
    Each argument type in a procedure header is followed by the name
    of a function [in square brackets] that will convert the argument
    to a printable TEXT.  This function name is generally
    Fmt.<something>, or the empty string if the argument type is TEXT.
    You don't need to IMPORT the Fmt interface, but you should IMPORT
    any other interfaces needed for format conversion.

    M3zume allows only a restricted set of argument types.  The names
    of argument types may not contain blanks (for example, "REF BOOLEAN"
    is not allowed); you may need to create an auxiliary interface that
    gives names to the types you want to use in your .evt file.  Open
    arrays are not allowed.

FILES
    /proj/m3/pkg/m3zume/src/*tem.{i3,m3,fv}              template files

DIAGNOSTICS 
    Poor.  Malformed event files may be accepted by the first phase of
    m3zume processing, only to be rejected during the second phase (m3pp).
    Even worse, if the first phase detects an error, the error message it
    produces will only show up in the output file as an unparsable
    statement flagged by m3pp.

EXAMPLES
    /proj/m3/pkg/m3zume/src/test/Sort*

BUGS
    The derived modules that m3zume produces may have unused interfaces,
    variables, and/or procedures.  Expect a few warnings from the
    compiler.

CAVEAT TO WIZARDS
    (Ignore this unless you have to modify a template file.)
    The IMPORT statements in template files must have the word "IMPORT"
    at the head of the line and have all the imports on a single line.
    This simplifies the task of complying with Modula-3's restriction
    that interfaces may be imported only once.

AUTHOR OF OBJECT
    John Hershberger, Marc Brown

AUTHOR OF DOCUMENTATION
    John Hershberger


Last modified on Sun Jul 19 22:07:51 PDT 1992 by johnh
