(* Copyright (C) 1992, Digital Equipment Corporation                         *)
(* All rights reserved.                                                      *)
(* See the file COPYRIGHT for a full description.                            *)
(*                                                                           *)
(* Last modified on Tue Jun 16 13:16:20 PDT 1992 by muller                       *)
(*      modified on Fri Jun 12 18:02:24 1992 by mhb                          *)

INTERFACE AsciiUtil;

IMPORT Rd, Scan, Text, Thread;
EXCEPTION Error;

PROCEDURE ScanLine (rd: Rd.T): Text.T RAISES {Thread.Alerted, Error};

PROCEDURE ScanRInt (rd: Rd.T): INTEGER
  RAISES {Thread.Alerted, Scan.BadFormat, Error};

PROCEDURE GetReal (rd: Rd.T; prefix: Text.T; VAR val: REAL)
  RAISES {Thread.Alerted, Scan.BadFormat, Error};

PROCEDURE GetInt (rd: Rd.T; prefix: Text.T; VAR val: INTEGER)
  RAISES {Thread.Alerted, Scan.BadFormat, Error};

PROCEDURE Get2Int (rd: Rd.T; prefix: Text.T; VAR v1, v2: INTEGER)
  RAISES {Thread.Alerted, Scan.BadFormat, Error};

PROCEDURE Get4Int (rd: Rd.T; prefix: Text.T; VAR v1, v2, v3, v4: INTEGER)
  RAISES {Thread.Alerted, Scan.BadFormat, Error};

PROCEDURE GetText (rd: Rd.T; prefix: Text.T; VAR val: Text.T)
  RAISES {Thread.Alerted, Error};
  
END AsciiUtil.
