(* Copyright (C) 1992, Digital Equipment Corporation                         *)
(* All rights reserved.                                                      *)
(* See the file COPYRIGHT for a full description.                            *)
(*                                                                           *)
(* Last modified on Fri Jul  3 15:28:05 PDT 1992 by meehan                   *)
(*      modified on Tue Jun 16 13:08:10 PDT 1992 by muller                   *)
(*      modified on Mon Jan 13 12:26:39 PST 1992 by mhb  *)
(*      modified on Thu Feb 7 14:12:23 PST 1991 by chan  *)
(*      modified on Wed Feb 6 15:30:37 PST 1991 by brooks  *)
(*      modified on Fri Sep 28 13:48:06 PDT 1990 by birrell  *)
(*      modified on Tue Jun 26 15:15:58 1990 by jdd  *)
(*      modified on Thu May 17 9:41:31 PDT 1990 by mcjones  *)
(*      modified on Fri May 11 12:54:07 PDT 1990 by steveg  *)
(*      modified on Wed May 17 16:19:47 PDT 1989 by gidi  *)
<* PRAGMA LL *>

MODULE TextEditVBT;

IMPORT Axis, Font, HVSplit, PaintOp, Pixmap, Pts, ScrollerVBT, Shadow,
         ShadowedVBT, Split, TextPort, TextPortPrivate, TextureVBT, VBT;

REVEAL
  T = Public BRANDED "TextEditVBT.T" OBJECT
      OVERRIDES
        init            := Init;
        getFont         := DefaultGetFont;
        setFont         := DefaultSetFont;
        getColorScheme  := DefaultGetColorScheme;
        setColorScheme  := DefaultSetColorScheme
      END;

PROCEDURE Init (v             : T;
                kind          : Kind              := Kind.Scrollable;
                style         : Shadow.Style      := Shadow.Style.Flat;
                scrollbar     : TextPort.Scroller := NIL;
                shadow        : Shadow.T          := NIL (* Shadow.None *);
                expandOnDemand                    := FALSE                  ):
  T =
  BEGIN
    IF shadow = NIL THEN shadow := Shadow.None END;
    IF v.port = NIL THEN
      v.port := NEW (TextPort.T).init (
                  singleLine := kind = Kind.SingleLine, colorScheme := shadow,
                  expandOnDemand := expandOnDemand)
    END;
    IF kind = Kind.Scrollable AND NOT v.port.singleLine THEN
      WITH hv = HVSplit.New (Axis.T.Hor) DO
        IF scrollbar = NIL THEN
          scrollbar := NEW (TextPort.Scroller).init (Axis.T.Ver, shadow)
        END;
        TextPort.SetScrollBar (v.port, scrollbar);
        Split.AddChild (hv, scrollbar);
        Split.AddChild (hv, NewBar (1.0, shadow));
        Split.AddChild (hv, v.port);
        EVAL ShadowedVBT.T.init (v, hv, shadow, style)
      END
    ELSE
      EVAL ShadowedVBT.T.init (v, v.port, shadow, style)
    END;
    RETURN v
  END Init;

TYPE Bar = TextureVBT.T OBJECT size: REAL OVERRIDES shape := Shape; END;

PROCEDURE NewBar (size: REAL; shadow: Shadow.T): Bar =
  BEGIN
    WITH v = NEW (Bar, size := size) DO
      EVAL TextureVBT.T.init (v, shadow.fg, Pixmap.Solid);
      RETURN v
    END
  END NewBar;

PROCEDURE Shape (v: Bar; ax: Axis.T; n: CARDINAL): VBT.SizeRange =
  VAR sr: VBT.SizeRange;
  BEGIN
    WITH hv = HVSplit.AxisOf (VBT.Parent (v)) DO
      IF hv = ax THEN
        sr.lo := Pts.ToScreenPixels (v, v.size, hv);
        sr.pref := sr.lo;
        sr.hi := sr.lo + 1;
        RETURN sr
      ELSE
        RETURN TextureVBT.T.shape (v, ax, n)
      END
    END
  END Shape;

PROCEDURE GetPort (v: T): TextPort.T =
  BEGIN
    RETURN v.port
  END GetPort;

PROCEDURE DefaultGetFont (v: T): Font.T =
  BEGIN
    RETURN TextPort.T.getFont (v.port)
  END DefaultGetFont;

PROCEDURE DefaultSetFont (v: T; font: Font.T) =
  BEGIN
    TextPort.T.setFont (v.port, font)
  END DefaultSetFont;

PROCEDURE DefaultGetColorScheme (v: T): PaintOp.ColorScheme =
  BEGIN
    RETURN TextPort.T.getColorScheme (v.port)
  END DefaultGetColorScheme;

PROCEDURE DefaultSetColorScheme (v: T; colorScheme: PaintOp.ColorScheme) =
  BEGIN
    TextPort.T.setColorScheme(v.port, colorScheme);
    IF v.port.scrollBar # NIL THEN
      ScrollerVBT.Colorize(v.port.scrollBar, colorScheme)
    END
  END DefaultSetColorScheme;

BEGIN
END TextEditVBT.
