(* Copyright (C) 1992, Digital Equipment Corporation *)
(* All rights reserved. *)
(* See the file COPYRIGHT for a full description. *)
(* *)
(* by Steve Glassman and Stephen Harrison *)
(* Last modified on Thu Sep 24 10:59:29 PDT 1992 by steveg *)

<*PRAGMA LL*>

INTERFACE Scale;

(* "Scale" provides a filter which uses a "ScaleFilter" to automatically 
   rescale its contents to fill the window.  *)

IMPORT ScaleFilter;

TYPE
  T <: PublicT;
  PublicT = ScaleFilter.T OBJECT keepAspectRatio := TRUE;  END;

(* A "Scale" is used exactly like a "ScaleFilter".  The only difference is
   that is automatically rescales its contents as the window is reshaped.

   If "keepAspectRatio" is false, then x and y are scaled independently so
   that the contents just fit in each direction.  If "keepAspectRatio" is
   true, then x and y are both scaled by the same amount such that the
   contents just fit in the larger direction and fit fine in the other
   direction. *)

END Scale.

