(* Copyright (C) 1992, Digital Equipment Corporation                         *)
(* All rights reserved.                                                      *)
(* See the file COPYRIGHT for a full description.                            *)
(*                                                                           *)
(* Last modified on Tue Aug 11 20:53:33 PDT 1992 by meehan *)
(*      modified on Tue Jun 16 13:08:25 PDT 1992 by muller *)
(*      modified on Fri Jun 12 01:27:21 1992 by mhb *)
(* modified on Fri Mar 27 01:59:50 1992 by steveg*)
<* PRAGMA LL *>

(* A "ReactivityVBT" is a filter that can make its child active,
   passive, dormant, and invisible.  The state {\em Active\/} does
   nothing; mouse and keyboard events are relayed to child.  {\em
   Passive\/} doesn't allow mouse or keyboard events to go to the child;
   in addition, the cursor is changed to "Cursor.NotReady".  {\em
   Dormant\/} doesn't send mouse or keyboard events to the child; it
   also grays out the child.  {\em Vanish\/} also doesn't send mouse
   or keyboard events to go to the child; in addition, it draws over
   the child in the background color, thereby making it invisible.

   If a descendant of a "ReactivityVBT" is painted, it will
   appear correctly.  That is, if the "ReactivityVBT" is in the
   vanished state, the descendant will not appear until the state
   changes, or if the "ReactivityVBT" is in a dormant state, the
   descendant will be grayed out.

   A "ReactivityVBT" also has the effect of passing on any
   miscellanous events to take the keyboard focus to the
   descendant that last acquired the keyboard focus. *)

INTERFACE ReactivityVBT;

IMPORT ETAgent, PaintOp, Rect, VBT;

TYPE
  State = {Active, Passive, Dormant, Vanish};
  T <: Public;
  Public =
    ETAgent.T OBJECT
    METHODS
      <* LL.sup = VBT.mu *>
      init (ch: VBT.T; colors: PaintOp.ColorScheme := NIL): T;
      <* LL = VBT.mu *>
      paintDormant (r: Rect.T; colors: PaintOp.ColorScheme);
    END;

(* The call "v.init(..)" initializes "v" as a "ReactivityVBT"
   with child "ch" and with an initial state of "Active".  If
   "colors" is "NIL", then "PaintOp.bgFg" is used instead.  The
   "colors" are used to draw the vanished and dormant states. *)

(* The implementation calls "v.paintDormant(r, colors)" to paint
   the part of "ch" bounded by rectangle "r" when "v"'s state
   is "Dormant".  The ``current colors'' of "v" are passed as
   "colors".  Initially, the current colors are those that were
   specified when the "ReactivityVBT" was initialized.  They can
   be changed using the "SetColors" procedure.  The default
   method paints a "Pixmap.Gray" texture using
   "colors.transparentBg".  *)

PROCEDURE New(ch: VBT.T; colors: PaintOp.ColorScheme := NIL): T;
(* "New(...)" is equivalent to "NEW(T).init(...)". *)

PROCEDURE Set (v: T; state: State);
(* Change "v"'s state and mark "v" for redisplay. *)

PROCEDURE Get (v: T): State;
(* Retrieve "v"'s current state. *)

PROCEDURE SetColors (v: T; colors: PaintOp.ColorScheme);
(* Change the colors that "v" uses for the "Dormant" and "Vanish"
   states.  If "v" is currently in the "Dormant" or "Vanish"
   state, mark "v" for redisplay. *)

END ReactivityVBT.











