(* Copyright (C) 1992, Digital Equipment Corporation                         *)
(* All rights reserved.                                                      *)
(* See the file COPYRIGHT for a full description.                            *)
(*                                                                           *)
(* Last modified on Sat Aug  1  0:26:55 PDT 1992 by meehan     *)
(*      modified on Tue Jun 16 13:08:28 PDT 1992 by muller     *)
(*      modified on Thu Dec 12  9:47:28 PST 1991 by mhb        *)

MODULE QuickSwitchVBT;

IMPORT ButtonVBT, Feedback, Multi, MultiClass, QuickBtnVBT,
       SwitchVBT, VBT;

REVEAL
  T = Public BRANDED OBJECT
      OVERRIDES
        init     := Init;
        callback := SwitchVBT.DefaultCallback;
      END;

PROCEDURE Init (v: T; f: Feedback.T; multiclass: MC := NIL): T =
  BEGIN
    EVAL QuickBtnVBT.T.init(v, f, Action);
    IF multiclass = NIL THEN multiclass := NEW (MC) END;
    MultiClass.Be (v, multiclass);
    MultiClass.BeChild(v, Multi.Child(f));
    RETURN v
  END Init;

PROCEDURE Action (selfAsButtonVBT: ButtonVBT.T; READONLY cd: VBT.MouseRec) =
  BEGIN
    NARROW(selfAsButtonVBT, T).callback(cd)
  END Action;

BEGIN
END QuickSwitchVBT.
