(* Copyright (C) 1992, Digital Equipment Corporation                         *)
(* All rights reserved.                                                      *)
(* See the file COPYRIGHT for a full description.                            *)
(*                                                                           *)
(* Last modified on Fri Jul 31  1:31:48 PDT 1992 by meehan     *)
(*      modified on Tue Jun 16 13:09:01 PDT 1992 by muller     *)
(*      modified on Mon Jun 15 18:42:08 1992 by mhb        *)


MODULE BorderedFeedbackVBT;

IMPORT BorderedVBT, Feedback, FeedbackClass, PaintOp, Pixmap, VBT;

REVEAL
  T = Public BRANDED OBJECT
        op: PaintOp.T
      OVERRIDES
        init := Init
      END;

  FC = FeedbackClass.T BRANDED OBJECT
       OVERRIDES
         normal  := Normal;
         excited := Excited;
       END;

PROCEDURE Init (v            : T;
                ch           : VBT.T;
                size         : Points  := Default;
                op                     := PaintOp.BgFg;
                feedbackclass: FC      := NIL           ): T =
  BEGIN
    EVAL BorderedVBT.T.init (
           v, ch, size / PtsPerMM, op, Pixmap.Solid);
    v.op := op;
    IF feedbackclass = NIL THEN feedbackclass := NEW (FC) END;
    FeedbackClass.Be (v, feedbackclass);
    Feedback.Normal (v);
    RETURN v
  END Init;

PROCEDURE Normal (fc: FC) =
  VAR
    pm: Pixmap.T;
    v : T        := fc.vbt;
  BEGIN
    IF Feedback.GetState (v) THEN
      pm := Pixmap.Solid;
    ELSE
      pm := Pixmap.Empty;
    END;
    BorderedVBT.SetColor (v, v.op, pm)
  END Normal;

PROCEDURE Excited (fc: FC) =
  VAR v: T := fc.vbt;
  BEGIN
    BorderedVBT.SetColor (v, v.op, Pixmap.Gray);
  END Excited;

BEGIN
END BorderedFeedbackVBT.
