(* Copyright (C) 1992, Digital Equipment Corporation                         *)
(* All rights reserved.                                                      *)
(* See the file COPYRIGHT for a full description.                            *)
(*                                                                           *)
(* Last modified on Thu Jul 30 23:17:14 PDT 1992 by meehan     *)
(*      modified on Tue Jun 16 13:09:03 PDT 1992 by muller     *)
(*      modified on Mon Jun 15 21:02:00 1992 by mhb        *)
(*      modified on Fri Mar 27 02:30:12 1992 by steveg     *)


MODULE BooleanVBT;

IMPORT ButtonVBT, Feedback, Filter, Multi, MultiClass, VBT;

REVEAL
  T = Public BRANDED OBJECT
      OVERRIDES
        callback := DefaultCallback;
        init     := Init
      END;

REVEAL
  MC = MultiClass.T BRANDED OBJECT
       OVERRIDES
         replace := Replace;
         pred    := Pred;
         succ    := Succ
       END; 

PROCEDURE Init (v: T; switch: ButtonVBT.T; multiclass: MC := NIL): T =
  BEGIN
    EVAL Filter.T.init (v, switch);
    (* Wipe out the Action on the switch. *)
    switch.action := Action;
    IF multiclass = NIL THEN multiclass := NEW (MC) END;
    MultiClass.Be (v, multiclass);
    IF Multi.Child (switch) # NIL THEN
      MultiClass.BeChild (v, Multi.Child (switch));
    END;
    RETURN v
  END Init;

PROCEDURE Action (s: ButtonVBT.T; READONLY cd: VBT.MouseRec) =
  BEGIN
    WITH f = Filter.Child(s) DO
      Feedback.SetState(f, NOT Feedback.GetState(f));
    END;
    NARROW(VBT.Parent(s), T).callback(cd);
  END Action;

PROCEDURE DefaultCallback (<* UNUSED *> self: T;
                           <* UNUSED *> READONLY cd: VBT.MouseRec) =
  BEGIN
  END DefaultCallback;

PROCEDURE Put (v: T; state: BOOLEAN) =
  BEGIN
    WITH s = Filter.Child (v), f = Filter.Child (s) DO
      Feedback.SetState (f, state)
    END
  END Put;

PROCEDURE Get (v: T): BOOLEAN =
  BEGIN
    WITH s = Filter.Child(v), f = Filter.Child(s) DO
      RETURN Feedback.GetState(f)
    END
  END Get;

PROCEDURE Replace (m: MC; ch, new: VBT.T)
  RAISES {Multi.NotAChild} =
  BEGIN
    WITH s = Filter.Child (m.vbt) DO
      Multi.Replace (s, ch, new)
    END
  END Replace;
    
PROCEDURE Succ (m: MC; ch: VBT.T): VBT.T
  RAISES {Multi.NotAChild} =
  BEGIN
    WITH s = Filter.Child (m.vbt) DO
      RETURN Multi.Succ (s, ch)
    END
  END Succ;
    
PROCEDURE Pred (m: MC; ch: VBT.T): VBT.T
  RAISES {Multi.NotAChild} =
  BEGIN
    WITH s = Filter.Child (m.vbt) DO
      RETURN Multi.Pred (s, ch)
    END
  END Pred;


BEGIN
END BooleanVBT.
