(* Copyright (C) 1989, Digital Equipment Corporation           *)
(* All rights reserved.                                        *)
(* See the file COPYRIGHT for a full description.              *)

(* Last modified on Tue Jun 23 10:39:52 PDT 1992 by schilit@xerox.com      *)
(* Last modified on Mon Nov 25 17:42:20 PST 1991 by meehan                 *)
(*      modified on Thu Jul 25 20:18:11 PDT 1991 by stolfi                 *)
(*      modified on Wed Apr 24 11:39:22 1991 by nichols@xerox.com          *)
(*      modified on Sun Jun 10 05:45:18 1990 by muller                     *)
(*      modified on Thu Nov  2 18:18:07 1989 by kalsow                     *)

INTERFACE Parse;

IMPORT NewFormatter AS Formatter, Ctypes, FBE;

TYPE
  Style = {SRC, EMULLER};
  Options =
    RECORD
      lowerCase : BOOLEAN;		(* allow lower-case keywords *)
      bodyFont: TEXT;           (* most text *)
      keywordFont: TEXT;        (* M3 keywords *)
      builtinIDFont: TEXT;	(* built-in ids *)
      procNameFont: TEXT;       (* procedure decls *)
      commentFont: TEXT;        (* most comments *)
      fixedCommentFont: TEXT;	(* no-reformat comments *)
      fixedFont: TEXT;          (* text and char literals *)
      offset: REAL;             (* indentation level in chars *)
      commentColumn: REAL;      (* where same-line comments go in chars *)
      style: Style;             (* END-alignment style *)
      alignDecls: BOOLEAN;      (* align VAR, CONST, etc. decls *)
      follow : BOOLEAN;		(* format as if comments follow decls *)
      breakType : Formatter.BreakType; (* controls line breaks *)
      callSpace : BOOLEAN;	(* write foo (x, y) instead of f(x, y) *)
    END;


PROCEDURE Init (         inputFile      : TEXT;
                         output         : Formatter.T;
                READONLY options        : Options;
                         calledFromEmacs: BOOLEAN      ) RAISES {FBE.Failed};

<* EXTERNAL *>
PROCEDURE initParser (infile                      : Ctypes.char_star;
                      output                      : Formatter.T;
                      emacs                       : BOOLEAN;
                      lowerCase                   : BOOLEAN;
                      bf, kf, bif, pf, cf, fcf, ff: FBE.Font;
                      offset, commentColumn       : REAL;
                      style                       : Style;
                      alignDecls                  : BOOLEAN;
                      breakType                     : Formatter.BreakType;
                      follow                 : BOOLEAN;
		      callSpace : BOOLEAN);

<*EXTERNAL*>
PROCEDURE yyparse ();

(* Called from the C code. *)
PROCEDURE CharWidth(f: Formatter.T; font: FBE.Font; c: CHAR): REAL;

VAR falsePred: Formatter.AlignPred;

END Parse.
