(* Copyright 1992 Digital Equipment Corporation. *)
(* Distributed only by permission. *)
(* Last modified on Thu Sep 24 11:01:56 PDT 1992 by mhb    *)
(*      modified on Thu Jul 23 22:37:36 PDT 1992 by johnh*)

MODULE SticksView;

IMPORT ColorName, DotsView, PaintOpCache, RectsVBT, Sort, View,
       ZeusPanel;

REVEAL
  T = DotsView.T BRANDED OBJECT
      OVERRIDES
        setPosition := SticksSetPosition;
      END;

PROCEDURE SticksSetPosition (<* UNUSED *> view : T;
                                          rects: RectsVBT.T;
                                          i    : CARDINAL;
                                          val  : Sort.Key    ) =
  BEGIN
    RectsVBT.Position(rects, i, FLOAT(i) - 0.5, 0.5,
                      FLOAT(i) + 0.5, FLOAT(val) + 0.5)
  END SticksSetPosition;

<* ColorName.NotFound *>

VAR 
  color := PaintOpCache.FromRGB(ColorName.ToRGB("Blue"));

PROCEDURE New (): View.T =
  BEGIN
    RETURN NEW(T).init(color)
  END New;

BEGIN
  ZeusPanel.RegisterView (New, "Sticks", "Sort");
END SticksView.
