(* Copyright (C) 1990, Digital Equipment Corporation           *)
(* All rights reserved.                                        *)
(* See the file COPYRIGHT for a full description.              *)

MODULE WiredStandard;

IMPORT TextStream;
IMPORT M3Context, M3CGo, M3CUnit, M3CUnit_priv, M3AST_AS, M3Conventions;

IMPORT M3AST_FE_F;

IMPORT StandardAsText;

PROCEDURE Set(c: M3Context.T) RAISES {}=
  VAR
    s := TextStream.Open(StandardAsText.Get());
    cu := M3AST_AS.NewCompilation_Unit();
    phases := M3CUnit.AllPhases;
  BEGIN
    M3Context.SetStandard(cu);
    cu.fe_uid := NEW(M3CUnit.Uid, filename := M3Conventions.Standard);
    M3CGo.CompileUnit(cu, c, s, Void, phases, NIL);
  END Set;

PROCEDURE Void(
    name: TEXT;
    unitType: M3CUnit.Type;
    context: M3Context.T;
    VAR (*out*) cu: M3AST_AS.Compilation_Unit
): BOOLEAN RAISES {}=
  BEGIN
    
  END Void;

BEGIN

END WiredStandard.
