(* Copyright (C) 1990, Digital Equipment Corporation           *)
(* All rights reserved.                                        *)
(* See the file COPYRIGHT for a full description.              *)

MODULE M3DepM3MFTool;

IMPORT Fmt, M3Args;

VAR
  tool_g: M3Args.T;

(*PUBLIC*)
PROCEDURE Get(): M3Args.T RAISES {}=
  BEGIN RETURN tool_g; END Get;

BEGIN
  tool_g := M3Args.New(Name, "Modula-3 'm3makefile' Generator", Version);
  M3Args.RegisterString(
      tool_g,
      MakeFile_Arg,
      Fmt.F(
          "name of m3makefile; default is \'%s\',\nuse \'%s\' for stdout",
          MakeFileDefault,
          StdOut_Arg),
      M3Args.Opt.Optional);
  M3Args.RegisterString(tool_g, AR_Arg, 
    "include 'Library(name)' entry");

  M3Args.MarkShared(AR_Arg);


END M3DepM3MFTool.


