(* Copyright (C) 1990, Digital Equipment Corporation           *)
(* All rights reserved.                                        *)
(* See the file COPYRIGHT for a full description.              *)

MODULE M3AST_AS_Init;

IMPORT AST, M3AST_AS, M3AST_AS_F;



PROCEDURE Record_type(n: M3AST_AS_F.Record_type): AST.NODE RAISES {}=
  BEGIN
    n.vEND_SRC_NODE := M3AST_AS.NewEND_SRC_NODE();
    RETURN n;
  END Record_type;


PROCEDURE Object_type(n: M3AST_AS_F.Object_type): AST.NODE RAISES {}=
  BEGIN
    n.vEND_SRC_NODE := M3AST_AS.NewEND_SRC_NODE();
    RETURN n;
  END Object_type;


PROCEDURE Exp_used_id(n: M3AST_AS_F.Exp_used_id): AST.NODE RAISES {}=
  BEGIN
    n.vUSED_ID := M3AST_AS.NewUSED_ID();
    RETURN n;
  END Exp_used_id;


PROCEDURE Case_st(n: M3AST_AS_F.Case_st): AST.NODE RAISES {}=
  BEGIN
    n.vEND_SRC_NODE := M3AST_AS.NewEND_SRC_NODE();
    RETURN n;
  END Case_st;


PROCEDURE For_st(n: M3AST_AS_F.For_st): AST.NODE RAISES {}=
  BEGIN
    n.vEND_SRC_NODE := M3AST_AS.NewEND_SRC_NODE();
    RETURN n;
  END For_st;


PROCEDURE If_st(n: M3AST_AS_F.If_st): AST.NODE RAISES {}=
  BEGIN
    n.vEND_SRC_NODE := M3AST_AS.NewEND_SRC_NODE();
    RETURN n;
  END If_st;


PROCEDURE Lock_st(n: M3AST_AS_F.Lock_st): AST.NODE RAISES {}=
  BEGIN
    n.vEND_SRC_NODE := M3AST_AS.NewEND_SRC_NODE();
    RETURN n;
  END Lock_st;


PROCEDURE Loop_st(n: M3AST_AS_F.Loop_st): AST.NODE RAISES {}=
  BEGIN
    n.vEND_SRC_NODE := M3AST_AS.NewEND_SRC_NODE();
    RETURN n;
  END Loop_st;


PROCEDURE Repeat_st(n: M3AST_AS_F.Repeat_st): AST.NODE RAISES {}=
  BEGIN
    n.vEND_SRC_NODE := M3AST_AS.NewEND_SRC_NODE();
    RETURN n;
  END Repeat_st;


PROCEDURE Try_st(n: M3AST_AS_F.Try_st): AST.NODE RAISES {}=
  BEGIN
    n.vEND_SRC_NODE := M3AST_AS.NewEND_SRC_NODE();
    RETURN n;
  END Try_st;


PROCEDURE Typecase_st(n: M3AST_AS_F.Typecase_st): AST.NODE RAISES {}=
  BEGIN
    n.vEND_SRC_NODE := M3AST_AS.NewEND_SRC_NODE();
    RETURN n;
  END Typecase_st;


PROCEDURE While_st(n: M3AST_AS_F.While_st): AST.NODE RAISES {}=
  BEGIN
    n.vEND_SRC_NODE := M3AST_AS.NewEND_SRC_NODE();
    RETURN n;
  END While_st;


PROCEDURE With_st(n: M3AST_AS_F.With_st): AST.NODE RAISES {}=
  BEGIN
    n.vEND_SRC_NODE := M3AST_AS.NewEND_SRC_NODE();
    RETURN n;
  END With_st;


PROCEDURE Block(n: M3AST_AS_F.Block): AST.NODE RAISES {}=
  BEGIN
    n.vEND_SRC_NODE := M3AST_AS.NewEND_SRC_NODE();
    RETURN n;
  END Block;

BEGIN
END M3AST_AS_Init.
