(* Copyright (C) 1990, Digital Equipment Corporation           *)
(* All rights reserved.                                        *)
(* See the file COPYRIGHT for a full description.              *)

MODULE Main;

(* This tool uses the standard tool framework provides by "M3ToolFrame".
   The interfaces and modules given by the user on the command line
   are all compiled, plus any others that are imported (transitively).
   Then the "M3ShowProc" tool is invoked on the resulting set (context)
   of ASTs. This will display the procedure names in each AST; see
   the M3ShowProcTool interface for details. *)

IMPORT Stdio;

IMPORT M3ToolFrame, M3ShowProcTool;
IMPORT M3Context;
IMPORT M3AST_all; (* this cannot be omitted; it defines the particular
                     revelations for all the AST nodes *)

PROCEDURE Run(c: M3Context.T; compileResult: INTEGER): INTEGER RAISES {}=
  BEGIN
    M3ShowProcTool.Run(c, Stdio.stdout);
    RETURN 0;
  END Run;

BEGIN
  EVAL M3ToolFrame.Startup(Run);
END Main.


