UNSAFE MODULE TimeDate_ux EXPORTS TimeDate, TimeDate_ux;

(***************************************************************************)
(*                      Copyright (C) Olivetti 1989                        *)
(*                          All Rights reserved                            *)
(*                                                                         *)
(* Use and copy of this software and preparation of derivative works based *)
(* upon this software are permitted to any person, provided this same      *)
(* copyright notice and the following Olivetti warranty disclaimer are     *) 
(* included in any copy of the software or any modification thereof or     *)
(* derivative work therefrom made by any person.                           *)
(*                                                                         *)
(* This software is made available AS IS and Olivetti disclaims all        *)
(* warranties with respect to this software, whether expressed or implied  *)
(* under any law, including all implied warranties of merchantibility and  *)
(* fitness for any purpose. In no event shall Olivetti be liable for any   *)
(* damages whatsoever resulting from loss of use, data or profits or       *)
(* otherwise arising out of or in connection with the use or performance   *)
(* of this software.                                                       *)
(***************************************************************************)

IMPORT Text;
IMPORT Unix, UnixMutex, Utime, M3toC;
IMPORT OSError, OSError_ux;


<*INLINE*> PROCEDURE GetTimeOfDay(VAR tv: Utime.struct_timeval) RAISES {OSError.E}=
  VAR
    zone: Utime.struct_timezone;
  BEGIN
    LOCK UnixMutex.errno DO
      IF Utime.gettimeofday(tv, zone) < 0 THEN OSError_ux.Raise() END;
    END;
  END GetTimeOfDay;


PROCEDURE Current(): TimeOfDay RAISES {OSError.E}=
  VAR
    t := NEW(TimeOfDay);
  BEGIN
    GetTimeOfDay(t^);
    RETURN t;
  END Current;


<*INLINE*> PROCEDURE UnixExpandedToExpanded(
    t: Utime.struct_tm_star;
    VAR e: Expanded)
    RAISES {}=
  BEGIN
    e.second := t.tm_sec;
    e.minute := t.tm_min;
    e.hour := t.tm_hour;
    e.day := VAL(t.tm_wday, Day);
    e.dayOfMonth := t.tm_mday;
    e.dayOfYear := t.tm_yday;
    e.month := VAL(t.tm_mon, Month);
    e.year := t.tm_year + 1900;
    e.daylightSavings := t.tm_isdst;
  END UnixExpandedToExpanded;


PROCEDURE Expand(t: TimeOfDay; VAR e: Expanded) RAISES {}=
  BEGIN
    LOCK UnixMutex.time DO
      UnixExpandedToExpanded(Utime.localtime(ADR(t.tv_sec)), e);
    END;
    e.microSecond := t.tv_usec;
  END Expand;


PROCEDURE ExpandGMT(t: TimeOfDay; VAR e: Expanded) RAISES {}=
  BEGIN
    LOCK UnixMutex.time DO
      UnixExpandedToExpanded(Utime.gmtime(ADR(t.tv_sec)), e);
    END;
    e.microSecond := t.tv_usec;
  END ExpandGMT;


PROCEDURE ToText(t: TimeOfDay): Text.T RAISES {}=
  VAR
    text: Text.T;
  BEGIN
    LOCK UnixMutex.time DO
      text := M3toC.CopyStoT(Utime.ctime(ADR(t.tv_sec)));
    END;
    RETURN Text.Sub(text, 0, MAX(Text.Length(text) - 1, 0));
  END ToText;

BEGIN

END TimeDate_ux.
