MODULE TextStream;

(***************************************************************************)
(*                      Copyright (C) Olivetti 1989                        *)
(*                          All Rights reserved                            *)
(*                                                                         *)
(* Use and copy of this software and preparation of derivative works based *)
(* upon this software are permitted to any person, provided this same      *)
(* copyright notice and the following Olivetti warranty disclaimer are     *) 
(* included in any copy of the software or any modification thereof or     *)
(* derivative work therefrom made by any person.                           *)
(*                                                                         *)
(* This software is made available AS IS and Olivetti disclaims all        *)
(* warranties with respect to this software, whether expressed or implied  *)
(* under any law, including all implied warranties of merchantibility and  *)
(* fitness for any purpose. In no event shall Olivetti be liable for any   *)
(* damages whatsoever resulting from loss of use, data or profits or       *)
(* otherwise arising out of or in connection with the use or performance   *)
(* of this software.                                                       *)
(***************************************************************************)

IMPORT Text, TextF;
IMPORT IO, IO_impl, HeapStream;


TYPE
  T = IO.Stream OBJECT
    text: Text.T;
    pos: CARDINAL := 0;
  OVERRIDES
    implFill := Fill;
    implSeek := Seek;
  END;


PROCEDURE Fill(s: T; VAR chars: ARRAY OF CHAR): INTEGER RAISES {}=
  VAR
    n := NUMBER(chars);
  BEGIN
    chars := SUBARRAY(s.text^, s.pos, n);
    INC(s.pos, n);
    RETURN n;
  END Fill;


PROCEDURE Seek(s: T; pos: CARDINAL): BOOLEAN RAISES {}=
  BEGIN
    s.pos := pos;
    RETURN TRUE;
  END Seek;


PROCEDURE Open(
    text: Text.T := NIL;
    name := "text")
    : IO.Stream
    RAISES {} =
  BEGIN
    IF text = NIL THEN
      RETURN HeapStream.Open(name);
    ELSE
      (* would have liked to use BufferStream here but unfortunately a text is
       a BRANDED REF ARRAY OF CHAR not just a REF ARRAY OF CHAR *)
      VAR
        s := NEW(T, text := text);
        length := Text.Length(text);
      BEGIN
        IO_impl.Init(s, NEW(REF ARRAY OF CHAR, MIN(MAX(length, 1), 256)),
            length, IO.OpenMode.Read, name := name);
            <* UNEXPECTED IO.Error *>
        RETURN s;
      END;
    END; (* if *)
  END Open;


PROCEDURE Convert(s: IO.Stream): Text.T RAISES {IO.Error}=
  VAR
    tell := IO.Tell(s);
    text := TextF.New(tell);
  BEGIN
    IO.Seek(s, 0);
    EVAL IO.GetN(s, SUBARRAY(text^, 0, tell)); <* UNEXPECTED IO.EndOfStream *>
    RETURN text;
  END Convert;


BEGIN

END TextStream.
