INTERFACE StdIO;

(***************************************************************************)
(*                      Copyright (C) Olivetti 1989                        *)
(*                          All Rights reserved                            *)
(*                                                                         *)
(* Use and copy of this software and preparation of derivative works based *)
(* upon this software are permitted to any person, provided this same      *)
(* copyright notice and the following Olivetti warranty disclaimer are     *) 
(* included in any copy of the software or any modification thereof or     *)
(* derivative work therefrom made by any person.                           *)
(*                                                                         *)
(* This software is made available AS IS and Olivetti disclaims all        *)
(* warranties with respect to this software, whether expressed or implied  *)
(* under any law, including all implied warranties of merchantibility and  *)
(* fitness for any purpose. In no event shall Olivetti be liable for any   *)
(* damages whatsoever resulting from loss of use, data or profits or       *)
(* otherwise arising out of or in connection with the use or performance   *)
(* of this software.                                                       *)
(***************************************************************************)

IMPORT IO;

(* The standard input, output and error streams. These will often be terminal
streams (though there is no guarantee that they will be). The effect of closing
any of these streams is undefined - don't do it.
  The standard input stream is readonly; the standard output and error streams
are write only. The standard output and error streams may sometimes be directed
to the same file but are given different streams.
  The streams are provided via inline procedures to make it obvious that they
are read only quantities (in the sense that the program cannot change them; the
standard input stream, for example, cannot be replaced by some other input
stream).
  For those concerned about efficiency and saving typing; use a WITH statement
e.g.
    WITH out = StdIO.Out() DO
      .....operations using standard output stream....
    END;
  The standard error stream is unbuffered i.e. it is automatically flushed
after every put operation. If the standard output stream is to a terminal it
is line buffered - i.e. it will be flushed whenever a put operation writes a
newline character. If the standard output stream is not to the terminal it is
not line buffered so users should always flush the standard output stream
before exiting a program. The implementation of 'StdIO' registers a
finalization procedure with 'Stop' so that if 'Stop.Stop' is called the
standard output stream will be flushed UNLESS some other thread has it locked
in which case nothing can be done.
  The standard streams are not usually seekable. Programs which seek on the
standard streams are not a good idea *)

(* For qualified import e.g. 'StdIO.In()' *)
<*INLINE*> PROCEDURE In(): IO.Stream RAISES {};
<*INLINE*> PROCEDURE Out(): IO.Stream RAISES {};
<*INLINE*> PROCEDURE Err(): IO.Stream RAISES {};

(* For unqualifed import e.g. 'FROM StdIO IMPORT StdIn;' then 'StdIn()' *) 
<*INLINE*> PROCEDURE StdIn(): IO.Stream RAISES {};
<*INLINE*> PROCEDURE StdOut(): IO.Stream RAISES {};
<*INLINE*> PROCEDURE StdErr(): IO.Stream RAISES {};

END StdIO.
