(* Copyright (C) 1989, 1990, Digital Equipment Corporation     *)
(* All rights reserved.                                        *)
(* See the file COPYRIGHT for a full description.              *)

(* File: Ctypes.i3                                             *)
(*      modified on Wed Feb  7 15:49:32 1990 by jerome         *)

INTERFACE Ctypes;


(* The Modula3 Type' Style *)

TYPE

  Double                     =  LONGREAL;
  DoubleStar                 =  UNTRACED REF Double;

  Char                       =  [-16_80 .. 16_7F];
  CharStar                   =  ADDRESS; (* in principle UNTRACED REF Char;
					    but it's so often used instead
					    of VoidStar .... *)
  CharStarStar               =  UNTRACED REF CharStar;
  CharStarStarStar           =  UNTRACED REF CharStarStar;
  UnsignedChar               =  [16_0 .. 16_FF];
  UnsignedCharStar           =  UNTRACED REF UnsignedChar;
  UnsignedCharStarStar       =  UNTRACED REF UnsignedCharStar;
  ConstCharStar              =  CharStar;
  ConstCharStarStar          =  CharStarStar;
  ConstUnsignedCharStar      =  UnsignedCharStar;

  Float                      =  REAL;
  FloatStar                  =  UNTRACED REF Float;
  LongFloat                  =  Double;

  Int                        =  INTEGER;
  IntStar                    =  UNTRACED REF Int;
  IntStarStar                =  UNTRACED REF IntStar;
  UnsignedInt                =  INTEGER;
  UnsignedIntStar            =  UNTRACED REF UnsignedInt;  

  Long                       =  INTEGER;
  LongStar                   =  UNTRACED REF Long;
  LongStarStar               =  UNTRACED REF LongStar;
  UnsignedLong               =  INTEGER;
  UnsignedLongStar           =  UNTRACED REF UnsignedLong;

  Short                      =  [-16_8000 .. 16_7FFF];
  ShortStar                  =  UNTRACED REF Short;
  ShortStarStar              =  UNTRACED REF ShortStar;
  UnsignedShort              =  [16_0 .. 16_FFFF];
  UnsignedShortStar          =  UNTRACED REF UnsignedShort;  

  Void                       =  ADDRESS;
  VoidStar                   =  ADDRESS;
  ConstVoidStar              =  ADDRESS;

  String4                    = UNTRACED REF ARRAY [0..3] OF CHAR;
  String16                   = UNTRACED REF ARRAY [0..15] OF CHAR;
  String64                   = UNTRACED REF ARRAY [0..63] OF CHAR;
  String256                  = UNTRACED REF ARRAY [0..255] OF CHAR;
  String1024                 = UNTRACED REF ARRAY [0..1023] OF CHAR;
  String4096                 = UNTRACED REF ARRAY [0..4095] OF CHAR;


(* The C Type's Style *)


TYPE

  double                     =  Double;
  double_star                =  DoubleStar;

  char                       =  Char;
  char_star                  =  CharStar;
  char_star_star             =  CharStarStar;
  char_star_star_star        =  CharStarStarStar;
  unsigned_char              =  UnsignedChar;
  unsigned_char_star         =  UnsignedCharStar;
  unsigned_char_star_star    =  UnsignedCharStarStar;
  const_char_star            =  ConstCharStar;
  const_unsigned_char_star   =  ConstUnsignedCharStar;

  float                      =  Float;
  float_star                 =  FloatStar;
  long_float                 =  Double;

  int                        =  Int;
  int_star                   =  IntStar;
  int_star_star              =  IntStarStar;
  unsigned_int               =  UnsignedInt;
  unsigned_int_star          =  UnsignedIntStar;

  long                       =  Long;
  long_star                  =  LongStar;
  long_star_star             =  LongStarStar;
  unsigned_long              =  UnsignedLong;
  unsigned_long_star         =  UnsignedLongStar;

  short                      =  Short;
  short_star                 =  ShortStar;
  short_star_star            =  ShortStarStar;
  unsigned_short             =  UnsignedShort;
  unsigned_short_star        =  UnsignedShortStar;

  void                       =  Void;
  void_star                  =  VoidStar;
  const_void_star            =  ConstVoidStar;

  string_4                   =  String4;
  string_16                  =  String16;
  string_64                  =  String64;
  string_256                 =  String256;
  string_1024                =  String1024;
  string_4096                =  String4096;


END Ctypes.
