(* Copyright (C) 1992, Digital Equipment Corporation           *)
(* All rights reserved.                                        *)
(* See the file COPYRIGHT for a full description.              *)

(* File: DriverConfig.i3                                       *)
(* Last modified on Tue Apr 21 17:17:23 PDT 1992 by muller     *)
(*      modified on Tue Feb 11 08:04:24 PST 1992 by kalsow     *)

UNSAFE MODULE DriverConfig;

IMPORT Ctypes, M3toC;

PROCEDURE GetArgs (): ArgList =
  VAR p: Ctypes.CharStarStar := args;  n := 0;  x: ArgList;
  BEGIN
    (* first, count the number of strings *)
    WHILE (p^ # NIL) DO INC (p, ADRSIZE (p^));  INC (n) END;

    (* allocate the result *)
    x := NEW (ArgList, n);

    (* and finally, build the text strings *)
    p := args;  n := 0;
    WHILE (p^ # NIL) DO
      x[n] := M3toC.StoT (p^);
      INC (p, ADRSIZE (p^));  INC (n);
    END;

    RETURN x;
  END GetArgs;

BEGIN
END DriverConfig.




