(* Copyright (C) 1992, Digital Equipment Corporation                         *)
(* All rights reserved.                                                      *)
(* See the file COPYRIGHT for a full description.                            *)

(* Last modified on Tue Feb 11 20:53:23 PST 1992 by muller                   *)

GENERIC INTERFACE Stack (Elt, EltStackADT);

(* The stack elements are stored in a link list.

   This interface has the shape of Elt. *)

TYPE
  T <: EltStackADT.T OBJECT METHODS
         new (): T; 
         END;

CONST
  Equal = T.equal;
  Copy  = T.copy;

END Stack.
