(* Last modified on Mon Oct 28 14:33:14 PST 1991 by muller *)

MODULE Txt;

IMPORT Text;

PROCEDURE Copy (t: T): T =
  (* Text.T's are immutable, so there is no need to copy them *)
  BEGIN
    RETURN t;
  END Copy;

PROCEDURE Hash (t: T; lessThan: CARDINAL): CARDINAL =
  (* A trivial hash function.  Probably needs to be made better *)
  BEGIN
    IF t = NIL OR Text.Length (t) < 1 THEN
      RETURN 0;
    ELSE 
      RETURN ORD (Text.GetChar (t, 0)) MOD lessThan; END;
  END Hash;

BEGIN
END Txt.
 
