{$LIST-
 $SYMTAB-
 CTOS Utility Operation Definitions
 23 JUN 86}

const
   vcbCode		= 2;
   sysTimeCode		= #240;
   saDGroupCode		= #242;
   rgSysErrorCode	= #248;
   versionCode		= #254;
   oRgPcbCode		= #28C;
   configBlkCode	= #2C8;
   sysDeviceNumCode	= #2D4;
   extCntlRegCode	= #2E4;
   grPortValCode	= #2E8;
   fontRamBufCode	= #2EC;

   iws = 0;				{Hardware type codes in Scb}
   aws210 = 1;
   aws220 = 2;
   aws230 = 2;
   aws240 = 3;
   nGen = 4;

type
   ascbType = record		{Application system configuration block}
      fhSwapFile		[000] :word;
      pVlpb			[002] :adsMem;
      fExecScreen		[006] :Boolean;
      fChkBoot			[007] :Boolean;
      ercRet			[008] :word;
      pbMsgRet			[010] :adsMem;
      cbMsgRet			[014] :word;
      reserved			[016] :array[01..3] of word;
      fTermination		[022] :Boolean;
      fVacate			[023] :Boolean;
      oLastTask			[024] :word;
      fExecFont			[026] :Boolean;
      bActionCode		[027] :byte;
      cParMemArray		[028] :word;
      rgbReservedForBatch1	[030] :array[01..15] of byte;
      rgbReservedForMail	[045] :array[01..19] of byte;
      sbUserName		[064] :lstring(30);
      sbPassword		[095] :lstring(12);
      sbCmdFile			[108] :lstring(78);
      rgbReservedForBatch2	[187] :array[1..93] of byte;
      fColor			[280] :Boolean;
      rgbColorBytes		[281] :array[0..7] of byte;
      reserved2			[289] :array[1..15] of byte;
   end;
   pAscbType = ads of ascbType;

   scbType = record			{System configuration block}
      systemBuildType	[00] :byte;
      osType		[01] :byte;
      saMinLL		[02] :word;
      saCurrLL		[04] :word;
      saCurrSL		[06] :word;
      saMaxSL		[08] :word;
      saMemMax		[10] :word;
      cPcb		[12] :word;
      cExch		[14] :word;
      cLinkBlk		[16] :word;
      cLinkBlkRes	[18] :word;
      cTrb		[20] :word;
      cIob		[22] :word;
      cFcb		[24] :word;
      cVhb		[26] :word;
      cUcb		[28] :word;
      cUfb		[30] :word;
      hardwareType	[32] :byte;
      clusterConfig	[33] :byte;
      fNoFileSystem	[34] :Boolean;
      fCommIop		[35] :Boolean;
      fMultiPartition	[36] :Boolean;
   end;
   pScbType = ads of scbType;

   txdbType = record				{Text descriptor block}
      prgCh		[00] :adsMem;
      cchMax		[04] :word;
      cchMac		[06] :word;
      ichCursor		[08] :word;
   end;

function GetpAscb(ppAscbRet :adsMem) :ercType; extern;

function GetpStructure(structCode, userNum :word; ppStructRet :adsMem)
	  :ercType; extern;

function LookUpField(fh :word; pBuffer :adsMem; sBuffer :word;
	  pbFieldName :adsMem; cbFieldNameMax :word; vars cbFieldName :word;
	  pbValue :adsMem; cbValueMax :word; vars cbValue :word;
	  fAllowWhiteSpace :Boolean) :ercType; extern;

function LookUpNumber(fh :word; pBuffer :adsMem; sBuffer :word;
	  pbFieldName :adsMem; cbFieldName :word; vars valueRet :word)
	  :ercType; extern;

function LookUpReset :ercType; extern;

function LookUpString(fh :word; pBuffer :adsMem; sBuffer :word;
	  pbFieldName :adsMem; cbFieldName :word; pbStringRet :adsMem;
	  cbStringMax :word; vars cbStringRet :word) :ercType; extern;

function ReadToNextField(fh :word; pBuffer :adsMem; sBuffer :word;
	  pLines :adsMem; cLinesMax, wLineSize :word; vars cLinesRet :word)
	  :ercType; extern;

function StringsEqual(psbString1, psbString2 :adsMem) :Boolean; extern;

function TextEdit(ch :char; vars txdb :txdbType) :ercType; extern;

function ULCMPB(pbString1, pbString2 :adsMem; cbString :word) :integer; extern;

{$SYMTAB+
 $LIST+}
