/*
 * Convergent Technologies
 *
 * FILE: graphics.c
 *
 * 2.1 C
 * Apr 18, 1986  MEC  Created
 * Jun 17, 1986  MDB  Changed graphics initialization
 * Jun 17, 1986  MEC  Bug fix in pushfloat()
 *
 * Make some graphics  calls from C.  This program  requires both
 * graphics hardware and floating point support.
 *
 * The C standard (Appendix A of Kernighan and Ritchie) says that
 * both "float" and "double"  parameters are pushed as "doubles".
 * This means 8 bytes on the processor stack (not the coprocessor
 * stack, which is what PL/M  does).  Unfortunately, the graphics
 * functions take 4-byte floating point parameters, so a trick is
 * needed to get these parameters pushed properly.
 *
 * The trick is: a function  "pushfloat" is provided that takes a
 * "float" or "double"  parameter and  returns a "long", which is
 * four bytes long.  The long integer can then be pushed.
 *
 * The function  "pushfloat" can be compiled  in a separate file,
 * but the external  declaration for it  *must* be present in the
 * source files where it is  used (it can be put in a .h file, of
 * course).  Otherwise, the compiler  will treat it as if it were
 * a function returning an integer, and that won't do!
 */


/*
 * This line *must* be present to use pushfloat().
 */
extern	long	pushfloat();

/*
 * The source  of pushfloat().  It  can be placed  in a  separate
 * file if you like.  If you try to change it you're likely to be
 * surprised, so don't.
 */

long
pushfloat(d)
double	d;
{
	float	f1;
	float	f2;

	f1 = d;
	f2 = 0;

	return (((long *) &f1 ) [0]);
}



/*
 * This is a sample graphics program.
 */

extern	char	fDevelopement;

#define	XMAX	100.0
#define	YMAX	 72.5
#define	RES	  1.0	/* Coordinate resolution */

extern	float	atof();
float	x1, y1, x2, y2;
float	res;

main(argc, argv)
int	argc;
char **	argv;
{
	fDevelopement = 1;

	ResetFrame (0);
	ResetFrame (1);
	ResetFrame (2);
	CheckErc(InitGraphics());
	CheckErc(OpenTempObject(pushfloat(0.0),  pushfloat(0.0),
	                        pushfloat(XMAX), pushfloat(YMAX)));

	for (res = XMAX/2; res > 0.1; res /= 2)
	{
		for (x1 = 0.0,    y1 = 0.0 ; x1 <= XMAX/2; x1 += res)
		{
			x2 = 0.0;
			y2 = YMAX/2 - x1 * (YMAX/XMAX);
			CheckErc(DrawLine(pushfloat(x1), pushfloat(y1),
			                  pushfloat(x2), pushfloat(y2)));
		}

		for (x1 = XMAX/2, y1 = 0.0 ; x1 <= XMAX  ; x1 += res)
		{
			x2 = XMAX;
			y2 = (x1 - XMAX/2) * (YMAX/XMAX);
			CheckErc(DrawLine(pushfloat(x1), pushfloat(y1),
			                  pushfloat(x2), pushfloat(y2)));
		}

		for (x1 = 0.0   , y1 = YMAX; x1 <= XMAX/2; x1 += res)
		{
			x2 = 0.0;
			y2 = YMAX/2 + x1 * (YMAX/XMAX);
			CheckErc(DrawLine(pushfloat(x1), pushfloat(y1),
			                  pushfloat(x2), pushfloat(y2)));
		}

		for (x1 = XMAX/2, y1 = YMAX; x1 <= XMAX  ; x1 += res)
		{
			x2 = XMAX;
			y2 = YMAX - (x1 - XMAX/2) * (YMAX/XMAX);
			CheckErc(DrawLine(pushfloat(x1), pushfloat(y1),
			                  pushfloat(x2), pushfloat(y2)));
		}

		Delay(5);
	}

	Delay(50);
	CheckErc(SetScreenVidAttr(1, 1));
	return (0);
}
