/* 
	Copyright 1989, 1990 XVT Software Inc. All rights reserved.
	May be used freely by licensed and registered users of XVT.
	May be distributed in source form only when embedded in an XVT 
	user's application.

	urlshelp.h - header that defines all default resources (dialogs, menus,
           about box, accelerators, ...) for shelp system

	Last Date Modified: 1/31/91
*/




/* standard help menu */
#ifndef NO_STD_HELP_MENU
#include "shelpmenu.h"
MENU M_HELP_MENU "~Help"
	ITEM M_HELP_HELP "~Help for help..." 
	ITEM M_HELP_EXTENDED "~Extended help..." 
	ITEM M_HELP_KEYS "~Keys help..."
	ITEM M_HELP_INDEX "Help ~index..." 
	SEPARATOR
	ITEM M_HELP_ABOUT "~About..." 
ACCEL M_HELP_HELP 		F10		SHIFT
ACCEL M_HELP_EXTENDED 	F2
ACCEL M_HELP_KEYS 		F9
ACCEL M_HELP_INDEX		F11

#endif /* !NO_STD_HELP_MENU */

/*
** Dialog boxes for help 
*/

/*
** Main dialog box
*/

/* next four dialogs for help system */

DIALOG DB_HELPMAIN      80,  24, 480, 184 "Help - " MODELESS
	BUTTON DLG_NEW,     24, 160,  80, 24 "~New..."
	BUTTON DLG_HIST,   120, 160, 112, 24 "~History..."
	BUTTON DLG_CANCEL, 248, 160,  80, 24 "~Cancel" 
	BUTTON DLG_OK,     346, 160,  104, 24 "Close ~all" DEFAULT

/*	
** Dialog box for help index 
*/

DIALOG DB_HELPTOPICS 136, 32, 368, 132 "Help Index - " MODELESS
	LISTBOX 4, 24, 16, 312, 88
	BUTTON DLG_CANCEL, 64, 104,  80, 24 "~Cancel" 
	BUTTON DLG_OK,     192, 104,  112, 24 "~Go to text" DEFAULT
	TEXT 15, 16, 8, 176, 8 "Select help topic ..."
 

/*
** Dialog box for help history
*/
DIALOG DB_HELPHIST 136, 32, 368, 132 "Help Topic History" MODELESS
	LISTBOX 4, 24, 16, 312, 88
	BUTTON DLG_CANCEL, 64, 104, 80, 24 "~Cancel"
	BUTTON DLG_OK,     192, 104, 112, 24 "~Go to text" DEFAULT
	TEXT 15, 16, 8, 256, 8 "Select help topic to revisit ..."

/*
** Dialog box for help hyperlinks
*/
DIALOG DB_HELPHYPER 136, 32, 368, 132 "Help Topic Links" MODELESS
	LISTBOX 4, 24, 16, 312, 88
	BUTTON DLG_CANCEL, 64, 104, 80, 24 "~Cancel"
	BUTTON DLG_OK,     192, 104, 112, 24 "~Go To Text" DEFAULT
	TEXT 15, 16, 8, 256, 8 "Select a topic to visit ..."

#transparent $$$ 
DLGTEMPLATE DB_HELPHISTPM LOADONCALL MOVEABLE DISCARDABLE 
BEGIN
    DIALOG "Help Topic History", DB_HELPHISTPM, 60, 27, 190, 130, FS_NOBYTEALIGN | 
                FS_NOMOVEWITHOWNER | FS_DLGBORDER | FS_BORDER | WS_CLIPSIBLINGS | 
                WS_SAVEBITS, FCF_SYSMENU | FCF_TITLEBAR
    BEGIN
        CONTROL "", 4, 17, 23, 156, 88, WC_LISTBOX, WS_GROUP | WS_TABSTOP | 
                WS_VISIBLE
        CONTROL "~Cancel", DLG_CANCEL, 114, 6, 32, 12, WC_BUTTON, BS_PUSHBUTTON | 
                WS_GROUP | WS_TABSTOP | WS_VISIBLE
        CONTROL "~Go To Text", DLG_OK, 46, 6, 48, 12, WC_BUTTON, BS_PUSHBUTTON | 
                BS_DEFAULT | WS_GROUP | WS_TABSTOP | WS_VISIBLE
        CONTROL "Select help topic to revisit ...", 15, 8, 116, 128, 8, 
                WC_STATIC, SS_TEXT | DT_LEFT | DT_TOP | WS_VISIBLE
    END
END
DLGTEMPLATE DB_HELPTOPICSPM LOADONCALL MOVEABLE DISCARDABLE 
BEGIN
    DIALOG "Help Topics - ", DB_HELPTOPICSPM, 60, 27, 190, 130, FS_NOBYTEALIGN | 
                FS_NOMOVEWITHOWNER | FS_DLGBORDER | FS_BORDER | WS_CLIPSIBLINGS | 
                WS_SAVEBITS, FCF_SYSMENU | FCF_TITLEBAR
    BEGIN
        CONTROL "", 4, 17, 23, 156, 88, WC_LISTBOX, WS_GROUP | WS_TABSTOP | 
                WS_VISIBLE
        CONTROL "~Cancel", DLG_CANCEL, 114, 6, 32, 12, WC_BUTTON, BS_PUSHBUTTON | 
                WS_GROUP | WS_TABSTOP | WS_VISIBLE
        CONTROL "~Go To Text", DLG_OK, 46, 6, 48, 12, WC_BUTTON, BS_PUSHBUTTON | 
                BS_DEFAULT | WS_GROUP | WS_TABSTOP | WS_VISIBLE
        CONTROL "Select help topic ...", 15, 8, 116, 128, 8, 
                WC_STATIC, SS_TEXT | DT_LEFT | DT_TOP | WS_VISIBLE
    END
END
DLGTEMPLATE DB_HELPHYPERPM LOADONCALL MOVEABLE DISCARDABLE 
BEGIN
    DIALOG "Help Topic Links", DB_HELPHYPERPM, 60, 27, 190, 130, FS_NOBYTEALIGN | 
                FS_NOMOVEWITHOWNER | FS_DLGBORDER | FS_BORDER | WS_CLIPSIBLINGS | 
                WS_SAVEBITS, FCF_SYSMENU | FCF_TITLEBAR
    BEGIN
        CONTROL "", 4, 17, 23, 156, 88, WC_LISTBOX, WS_GROUP | WS_TABSTOP | 
                WS_VISIBLE
        CONTROL "~Cancel", DLG_CANCEL, 114, 6, 32, 12, WC_BUTTON, BS_PUSHBUTTON | 
                WS_GROUP | WS_TABSTOP | WS_VISIBLE
        CONTROL "~Go To Text", DLG_OK, 46, 6, 48, 12, WC_BUTTON, BS_PUSHBUTTON | 
                BS_DEFAULT | WS_GROUP | WS_TABSTOP | WS_VISIBLE
        CONTROL "Select a topic to visit ...", 15, 8, 116, 128, 8, 
                WC_STATIC, SS_TEXT | DT_LEFT | DT_TOP | WS_VISIBLE
    END
END
DLGTEMPLATE DB_HELPMAINPM LOADONCALL MOVEABLE DISCARDABLE 
BEGIN
    DIALOG "Help - ", DB_HELPMAINPM, 25, -6, 257, 192, FS_NOBYTEALIGN | 
                FS_NOMOVEWITHOWNER | FS_DLGBORDER | FS_BORDER | WS_CLIPSIBLINGS | 
                WS_SAVEBITS, FCF_SYSMENU | FCF_TITLEBAR
    BEGIN
        CONTROL "~New...", DLG_NEW, 12, 8, 39, 14, WC_BUTTON, BS_PUSHBUTTON | 
                WS_TABSTOP | WS_VISIBLE
        CONTROL "~History...", DLG_HIST, 74, 8, 39, 14, WC_BUTTON, BS_PUSHBUTTON | 
                WS_TABSTOP | WS_VISIBLE
        CONTROL "~Cancel", DLG_CANCEL, 136, 8, 39, 14, WC_BUTTON, BS_PUSHBUTTON | 
                WS_TABSTOP | WS_VISIBLE
        CONTROL "C~lose all", DLG_OK, 200, 8, 39, 14, WC_BUTTON, BS_PUSHBUTTON | 
                WS_TABSTOP | WS_VISIBLE
    END
END
$$$


/* NLS STRINGS */

#ifndef NLS_START
#define NLS_START 9200
#endif

/**** vhelp.c ****/
STRING NLS_START+64	"Can't access help file %s."
STRING NLS_START+65	"Out of memory."
STRING NLS_START+66	"Error reading help file."
STRING NLS_START+67	"No help on this topic yet."
STRING NLS_START+68	"Can't access data in help file."
STRING NLS_START+69	"Can't show help text dialog."
STRING NLS_START+70	"Can't show help topics dialog."
STRING NLS_START+71	"Can't change to help directory."
STRING NLS_START+72	"Can't get current directory."
STRING NLS_START+73	"Can't open '%s'"
STRING NLS_START+74	"Please locate '%s'"
STRING NLS_START+75	"Illegal file name: %s"

/**** shelp.c ****/
STRING NLS_START+120 "h.help"
STRING NLS_START+121 "h.default"
STRING NLS_START+122 "h.keys"
STRING NLS_START+123 "[sys]<sys>"
STRING NLS_START+124 "~Next topic"
STRING NLS_START+125 "~Previous topic"
STRING NLS_START+126 "~Return"
STRING NLS_START+127 "~Backtrack"
STRING NLS_START+128 "Error adding index %s"
STRING NLS_START+129 "Can't read topic text."
STRING NLS_START+130 "Can't access data in help file."
STRING NLS_START+131 "Can't load string resource: %d"
STRING NLS_START+132 "Can't create help window"
STRING NLS_START+133 "Help title"
STRING NLS_START+134 "Can't create window controls"
STRING NLS_START+135 "Can't display help text"
STRING NLS_START+136 "Can't show history topics dialog."
STRING NLS_START+137 "Can't show main help dialog."
STRING NLS_START+138 "Can't change to directories"
STRING NLS_START+139 "%s%s.hlp"
STRING NLS_START+140 "No context found"
STRING NLS_START+141 "No history to view"
STRING NLS_START+142 "Please select a help file"
STRING NLS_START+143 "Invalid help file - recompile and try again"
STRING NLS_START+144 "Application and system topic not found"
STRING NLS_START+145 "Too many items in the history list, resetting"
STRING NLS_START+146 "Too many lines to format in help topic"
STRING NLS_START+147 "system help file (%s) not found"
STRING NLS_START+148 "Too many help windows open - close existing windows before opening new ones"
STRING NLS_START+149 "The word you have selected does not match any topic."
STRING NLS_START+150 "For security reasons, you have been prevented from accessing a help file other than that of your application."
STRING NLS_START+151 "Unable to load the help index for this application - help file may not exist."
STRING NLS_START+152 "Unable to load the help index of the system help file (%s)"
STRING NLS_START+153 "The word you have selected only matches the current topic"

