
pragma Page(1);
/*-----------------------------------------------------------------------------
 When sequential access medium is used and the service is located remotely
 (i.e. at the server or perhaps across the network), we must determine the
 largest size request that may be sent over the intervening transport
 layer(s).  Note that it is NOT relevant to piecemealing if the service is
 located on a remote processor board within the server; this is because the
 sequential access data transfer requests are styled 'dmaRemote' and the
 service, is responsible for transporting data between
 processors. OpenDevice works just fine for this purpose because
 a) the request is routed by device specification (so we know it gets all the
 way to the service) and b) it has a request parameter block that can be made
 arbitrarily large to test the maximum size.  Use binary search techniques to
 quickly zero in on the maximal block size.
 ----------------------------------------------------------------------------*/

private unsigned Calculate_piecemeal_size(void) {

   unsigned handle, max_piecemeal_size = SEGMENT_SIZE - PAGE_SIZE,
      min_piecemeal_size = PAGE_SIZE,
      piecemeal_size = SEGMENT_SIZE - PAGE_SIZE;

   while (TRUE) {
      if (OpenDevice(&handle, &archive.spec[1], archive.spec[0], NULL,
                        piecemeal_size, 0, NULL, 0) == ercXbufTooSmall) {
         max_piecemeal_size = piecemeal_size;
         piecemeal_size = (piecemeal_size / 2 + min_piecemeal_size / 2)
                           & ~(PAGE_SIZE - 1);
      } else if (max_piecemeal_size - piecemeal_size > PAGE_SIZE) {
         min_piecemeal_size = piecemeal_size;
         piecemeal_size = (piecemeal_size / 2 + max_piecemeal_size / 2
                           + PAGE_SIZE - 1) & ~(PAGE_SIZE - 1);
      } else
         return(piecemeal_size);
   }

}

