/*****************************  MODULE HEADER  *******************************/
/*                                                                           */
/*                                                                           */
/*  MACHINE:                LANGUAGE:  Metaware C            OS: CTOS        */
/*                                                                           */
/*  archive.h                                                                */
/*                                                                           */
/*  HISTORY:                                                                 */
/*  --------                                                                 */
/*                                                                           */
/*  MM/DD/YY  VVVV/MM  PROGRAMMER    /  DESCRIPTION                          */
/*                                                                           */
/*  07/10/92  122K.10  D. Gilson     /  P15511893 Suppress Confirm msg should*/
/*                                      not be tied to non-interactive       */
/*  12/18/91  130E.09  D. Gilson     /  Added Multiple device support        */
/*                                   /  defined MAX_NUMBER_OF_DEVICES        */
/*  11/23/91  130E.08  D. Gilson     /  Change the value for                 */
/*                                   /  DEFAULT_DIRECTORY_PAGES from 30 to 40*/
/*                                   /  This effectively changes the default */
/*                                   /  number of file in a directory from   */
/*                                   /  750 to 1000.                         */
/*  11/13/91  130D.07  D. Gilson     /  Change the value for                 */
/*                                   /  DEFAULT_DIRECTORY_PAGES from 3 to 30 */
/*                                   /  This effectively changes the default */
/*                                   /  number of file in a directory from   */
/*                                   /  75 to 750.                           */
/*  10/07/91  130D.06  D. Gilson     /  Include BSWA_SIZE and BUFFER_SIZE    */
/*  08/19/91  130B.05  P. Johansson  /  RSAM buffer size dynamic at runtime. */
/*  07/19/91  130A.04  P. Johansson  /  Add creation time to BOF sentinel.   */
/*  03/11/91  121H.03  P. Johansson  /  Defaults for directory creation.     */
/*  03/06/91  121H.02  P. Johansson  /  Support 12.0 half-inch tape labels.  */
/*  01/23/91  121F.01  P. Johansson  /  Data structure definitions changed.  */
/*  12/13/90  121E.00  P. Johansson  /  Created.                             */
/*                                                                           */
/*                    PROPRIETARY  PROGRAM  MATERIAL                         */
/*                                                                           */
/*  THIS MATERIAL IS PROPRIETARY TO UNISYS CORPORATION AND IS NOT TO         */
/*  BE REPRODUCED, USED OR DISCLOSED EXCEPT IN ACCORDANCE WITH PROGRAM       */
/*  LICENSE OR UPON WRITTEN AUTHORIZATION OF THE PATENT DIVISION OF          */
/*  UNISYS CORPORATION, DETROIT, MICHIGAN 48232, USA.                        */
/*                                                                           */
/*  COPYRIGHT (C) 1990 UNISYS CORPORATION. ALL RIGHTS RESERVED               */
/*                                                                           */
/*****************************************************************************/
/*                                                                           */
/*  UNISYS BELIEVES THAT THE SOFTWARE FURNISHED HEREWITH IS ACCURATE         */
/*  AND RELIABLE, AND MUCH CARE HAS BEEN TAKEN IN ITS PREPARATION. HOWEVER,  */
/*  NO RESPONSIBILITY, FINANCIAL OR OTHERWISE, CAN BE ACCEPTED FOR ANY       */
/*  CONSEQUENCES ARISING OUT OF THE USE OF THIS MATERIAL, INCLUDING LOSS     */
/*  OF PROFIT, INDIRECT, SPECIAL, OR CONSEQUENTIAL DAMAGES, THERE ARE NO     */
/*  WARRANTIES WHICH EXTEND BEYOND THE PROGRAM SPECIFICATION.                */
/*                                                                           */
/*  THE CUSTOMER SHOULD EXERCISE CARE TO ASSURE THAT USE OF THE SOFTWARE     */
/*  WILL BE IN FULL COMPLIANCE WITH LAWS, RULES AND REGULATIONS OF THE       */
/*  JURISDICTIONS WITH RESPECT TO WHICH IT IS USED.                          */
/*                                                                           */
/**************************  END OF MODULE HEADER  ***************************/

#define CONFIG_FILE_PARAM 1		/* Configure Sequential Access Dev */

#define RESTORE_ARCHIVE_DATASET_PARAM 1	/* Restore Archive */
#define FILE_LIST_FROM_PARAM 2
#define FILE_LIST_TO_PARAM 3

#define FILE_LIST_PARAM 1		/* Selective Archive */
#define SELECTIVE_ARCHIVE_DATASET_PARAM 4

#define DEVICE_PARAM 1			/* Tape Erase/Retension */
#define NONINTERACTIVE_PARAM 2

#define VOLUME_PARAM 1			/* Volume Archive */
#define VOLUME_PASSWORD_PARAM 2
#define VOLUME_ARCHIVE_DATASET_PARAM 6

#define ARCHIVE_SIZE 2097152
#define DEFAULT_DIRECTORY_PAGES 40
#define DEFAULT_DIRECTORY_PROTECTION 15
#define MAX_DEVICE_LENGTH 12
#define MAX_NODE_LENGTH 12
#define MAX_VOLUME_LENGTH 12
#define MAX_DIRECTORY_LENGTH 12
#define MAX_FILENAME_LENGTH 50
#define MAX_PASSWORD_LENGTH 12
#define MAX_FILE_SPECIFICATION_LENGTH 105
#define MIN_ARCHIVE_SIZE 32768
#define MAX_NUMBER_OF_DEVICES 4

typedef struct {
   char node[MAX_NODE_LENGTH + 1];
   Boolean volume_may_have_changed;
   Boolean volume_encrypted;
   char volume[MAX_VOLUME_LENGTH + 1];
   char volume_password[MAX_PASSWORD_LENGTH + 1];
   char device[MAX_VOLUME_LENGTH + 1];
   char device_password[MAX_PASSWORD_LENGTH + 1];
   char directory[MAX_DIRECTORY_LENGTH + 1];
   char directory_password[MAX_PASSWORD_LENGTH + 1];
   char directory_protection;
   unsigned directory_pages;
} path_type;

typedef struct {
   unsigned handle;
   unsigned user_count;
   unsigned long vda_bom;
   unsigned long vda_eom;
   unsigned long free_pages;
   unsigned long memory_for_structures;
   Boolean local;
   Boolean may_have_changed;
   Boolean invalid;
} filesys_type;

typedef struct {
   unsigned msg_exch;
   unsigned handle;
   unsigned sequence;
   unsigned current_position;
   unsigned target_position;
   unsigned file_num;
   unsigned file_checksum;
   unsigned long lfa;
   unsigned long size;
   unsigned block_size;
   unsigned target_density;
   unsigned target_speed;
   unsigned piecemeal_size;
   unsigned long creation_time;
   Boolean inbound;
   Boolean sequential;
   Boolean old_format;
   Boolean first_volume;
   Boolean erase_on_close;
   Boolean rewind_on_close;
   char (*rswa)[130];
   void *rsam_buffer;
   unsigned rsam_buffer_size;
   char spec    [MAX_NUMBER_OF_DEVICES] [MAX_FILE_SPECIFICATION_LENGTH + 1];
   char password[MAX_NUMBER_OF_DEVICES] [MAX_PASSWORD_LENGTH + 1];
   unsigned device_num;
   unsigned device_num_last;
} archive_type;

typedef struct {
   unsigned checksum;
   unsigned fileHeaderPageNum;
   char fileName[MAX_FILENAME_LENGTH + 1];
   char password[MAX_PASSWORD_LENGTH + 1];
   char dirName[MAX_DIRECTORY_LENGTH + 1];
   unsigned fileHeaderNum;
   unsigned extensionHeaderNumChain;
   char headerSequenceNum;
   char fileClass;
   char accessProtection;
   unsigned long dirPageLfa;
   unsigned long creationDT;
   unsigned long modificationDT;
   unsigned long accessDT;
   unsigned long expirationDT;
   Boolean fNoSave;
   Boolean fNoDirPrint;
   Boolean fNoDelete;
   unsigned long endOfFileLfa;
   unsigned long defaultExpansion;
   unsigned freeRunIndex;
   unsigned userObjectType;
   char rgbDistrix[62];
   char fReadOnly;
   char bDosMagic;
   char bDosAttribute;
   unsigned parentFhbNum;
   char cLink;
   char ObjectType;
   char application[64];
} archive_fhb_type;

typedef struct {
   unsigned count[10];
} summary_type;

#define TOTAL_FILES 1
#define BACKED_UP_OK 2
#define RESTORED_OK 2
#define IO_ERRORS 3
#define OTHER_ERRORS 4
#define NOT_BACKED_UP 5
#define UNABLE_TO_RESTORE 5
#define TOTAL_FILE_HEADERS 6
#define CURRENT_FILE_HEADER 7
#define CURRENT_FILE 7
#define PROCESSED 7
#define BYPASSED 8

typedef struct {
   unsigned msg_exch;
   unsigned handle;
   unsigned long size;
   unsigned long lfa;
   char filespec[MAX_FILE_SPECIFICATION_LENGTH + 1];
   char password[MAX_PASSWORD_LENGTH + 1];
} target_type;

#define BSWA_SIZE 130
#define BUFFER_SIZE 1024
typedef struct {
   unsigned video_semaphore;
   unsigned prev_signature;
   char prev_msg[256];
   Boolean interrupted;
   char (*bswa)[BSWA_SIZE];
   char (*buffer)[BUFFER_SIZE];
   unsigned page;
   unsigned line;
   char filespec[MAX_FILE_SPECIFICATION_LENGTH + 1];
   char password[MAX_PASSWORD_LENGTH + 1];
} journal_type;

typedef struct {
   unsigned from_specs;
   unsigned to_specs;
   unsigned long backup_after;
   Boolean confirm;
   Boolean display_structures;
   Boolean file_trailer;
   Boolean list_only;
   Boolean merge;
   Boolean noninteractive;
   Boolean no_overwrite;
   Boolean overwrite_OK;
   Boolean suppress_backup;
   Boolean suppress_verify;
   Boolean verify_write;
   Boolean volume_archive;
   Boolean write_archive;
   Boolean suppress_confirmation_msg;
} vlpb_type;

typedef _unpacked struct {
   enum {MODE, ABORT, SYNC, BOV, BOF, DATA, SKIP, EOF, EOV, EOD} ctrl;
   struct {
      Boolean final_close :1;
      Boolean write :1;
      Boolean sequential :1;
      Boolean checksum_error :1;
   } mode;
   unsigned return_exch;
   void *base;
   unsigned size;
   void *data;
   unsigned available;
} iob_type;

typedef struct {
   unsigned signature;		/* 0x99B5 */
   unsigned record_type;	/* Either BOV, EOV or EOD */
   unsigned checksum;
   char description[10];	/* "ARKIVE BOV", "ARKIVE EOV", "ARKIVE EOD" */
   unsigned sequence;		/* Sequence number (0, 1, 2...) this volume */
   unsigned total_files;	/* Total ELIGIBLE for archive (not actual) */
   unsigned file_num;		/* Starting file number this volume */
   unsigned block_size;		/* Physical block size (0 if not applicable) */
   unsigned long creation_time;
   char reserved1[4];
   char creator[80];		/* Executive command name used to invoke */
   char version[64];		/* 'sbVerRun' of creating program */
   char oem_text[10];	 	/* Reserved for OEM's (from message file) */
   char reserved2[326];
} archive_label_type;

#define ARCHIVE_SIGNATURE 0x99B5

typedef struct {
   unsigned signature;
   unsigned record_type;
   unsigned checksum;
   unsigned long pages_data;
   unsigned long file_checksum;
   char node[MAX_NODE_LENGTH + 1];
   char volume[MAX_VOLUME_LENGTH + 1];
   char directory[MAX_DIRECTORY_LENGTH + 1];
   char directory_password[MAX_PASSWORD_LENGTH + 1];
   char directory_protection;
   unsigned directory_pages;
   char directory_type;
   char filename[MAX_FILENAME_LENGTH + 1];
   char file_password[MAX_PASSWORD_LENGTH + 1];
   char protection;
   struct {
      Boolean suppress_backup :1;
      Boolean hidden_file :1;
      Boolean prevent_delete:1;
      Boolean read_only :1;
      Boolean file_trailer :1;
   } control;
   char ms_dos_magic;
   char ms_dos_attribute;
   unsigned object_type;
   unsigned long creation_date;
   unsigned long modification_date;
   unsigned long access_date;
   unsigned long expiration_date;
   unsigned long eof_lfa;
   char distrix_info[62];
   char application_info[64];
   unsigned long dataset_creation_time;
   char reserved[222];
} archive_sentinel_type;

/*-----------------------------------------------------------------------------
 The older format QIC and 1/2" tape archives used an internal record
 organization called VAM (or MagVAM or QicVAM but at any rate not to be
 confused with Video Access Method!) for Variable (Length) Access Method.  The
 fundamental organization of the archive medium was into blocks (typically
 1536 bytes for non-SCSI QIC devices, 64,512 bytes for SCSI QIC and a
 variable, user configurable amount for 1/2" tape) that were the fundamental
 until of data transfer.  Each block is prefixed with an 8-byte header (see
 below) with a "magic" signature to identify it.  Subsequent to this header,
 the block is organized into records of either 256 or 512 byte lengths.  Each
 record is preceeded by a 6-byte header (see below).  Records may span blocks
 but record headers are not allowed to span blocks, that is, if the end of
 block residual is less than 6 bytes these bytes are to be discarded from the
 input stream and the record header is expected in the next block.  Record
 lengths of 256 bytes are used exclusively for compressed File Header Block
 (FHB) images while the 512 byte records are always data.  The logical end of
 the archive is signalled by a record header with a record length of zero. */

typedef struct {
   char backup_hdr[18];
   char backup_file_num[4];
   char backup_sequence[4];
   char backup_block_size[5];
   char reserved[24];
   char backup_time[25];
   char backup_id[80];
   unsigned reserved1[5];
   unsigned total_files;
   unsigned reserved2[340];
} vam_volume_hdr_type;

#define HALF_INCH_LABEL_SIZE 160u

typedef struct {
   unsigned signature;
   unsigned volume_sequence;
   unsigned block_sequence;
   unsigned record_residual;
} vam_block_hdr_type;

#define OLD_TAPE_MAGIC 0xA13D

typedef struct {
   unsigned size;
   unsigned file_num;
   unsigned sequence;
} vam_record_hdr_type;

#define RSAM_FHB_SIZE 256u
#define VAM_FHB_SIZE 256u
