

Public  QicIsr



	EXTRN QicInterrupt:     FAR;



DATA SEGMENT PUBLIC 'DATA'

	EXTRN QicStatusPort:    WORD;
	EXTRN QicControlPort:   WORD;
	EXTRN QicControlReg:    BYTE;
	nBogusInterrupts DW 0
	PUBLIC nBogusInterrupts
	bBogusStatus DB 0	
	PUBLIC bBogusStatus
	bLastControl DB 0
	PUBLIC bLastControl

DATA ENDS
DGroup GROUP DATA

QicIsrCode Segment Public 'CODE'

Assume CS : QicIsrCode, DS : DGroup, Es: Nothing, SS: Nothing

;
;	QicIsr: procedure public;
;

QicIsr PROC FAR

; see if tape enabled?
;
	MOV ax, QicControlPort
	CMP ax,0
	JE QicIsrRet
	MOV dx,ax
	IN  al, dx
	MOV  bLastControl,al
	TEST al, 80h; if set, then interrupts enabled
	JZ  QicIsrRet
;
; Interrupts are inabled, is this one the one we're looking for?
; Check status byte for pending interrupt
;
	MOV dx, QicStatusPort
	IN al, dx
	TEST al, 04h; fException
	JNZ GotQicInt
	TEST al, 10h; fTerminalcount
	JNZ GotQicInt
	TEST al, 20h; fEndCommand
	JNZ GotQicInt
;
; Bogus interrupt
;
	INC nBogusInterrupts
	MOV bBogusStatus,al
;
; This is not one of our interrupts, give it back
;
QicIsrRet:
	XOR ax, ax
	RET
;
; handle interrupt
GotQicInt:
	Xor  ah,ah; Save the status byte for the call to QicInterrupt
	Push ax
;
; Turn off interrupt/LED and clear r/w op flags
	MOV al,QicControlReg
	MOV dx, QicControlPort
	AND al,1Fh
	MOV QicControlReg,al
	OUT dx,al
;
; Clear counter interrupt
	MOV dl,088h
	MOV al,0ffh
	OUT dx,al
;
	Call QicInterrupt
;
	MOV  al, 0ffh
	RET


QicIsr ENDP

QicIsrCode Ends

End
2                                                                     @  ľ                                                                                                                                                                                                                                                                                                                                                                                                                                                                                     ,    
 j   ^         (          `             @       `           @       `     ) P
x 0          x   x   x   x  
Courier 72                                                                                                                                                                                                                                                                                                                                                          G           "    10.0                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               