
; misc math routines

;  last updated 10/21/88 by P. Johansson
;  ResetStack moved to CommonSubs_All.Asm
;  QDiv16, QMul16 copied from Standard Software Quad.Asm

PUBLIC Mul32, Div32, Mod32, MDiv32, QDiv16, QMul16

Math32     SEGMENT PUBLIC 'CODE'
ASSUME CS: Math32

; q=QDiv16(q,w)

QDiv16     PROC FAR

           PUSH    BP
           MOV     BP,SP
           XOR     DX,DX
           MOV     AX,WORD PTR [BP+10]
           DIV     WORD PTR [BP+6]
           MOV     CX,AX
           MOV     AX,WORD PTR [BP+8]
           DIV     WORD PTR [BP+6]
           MOV     DX,CX
           POP     BP
           RET     6

QDiv16     ENDP

; q=QMul16(q,w)

QMul16     PROC FAR

           PUSH    BP
           MOV     BP,SP
           MOV     AX,WORD PTR [BP+8]
           MUL     WORD PTR [BP+6]
           MOV     BX,AX
           MOV     CX,DX
           MOV     AX,WORD PTR [BP+10]
           MUL     WORD PTR [BP+6]
           ADD     AX,CX
           MOV     DX,AX
           MOV     AX,BX
           POP     BP
           RET     6

QMul16     ENDP

; q=Mul32(w1,w2)

MUL32      PROC FAR

           PUSH    BP
           MOV     BP,SP
           MOV     AX,[BP+6]
           MUL     WORD PTR [BP+8]
           POP     BP
           RET     4H

MUL32      ENDP


; w0=Div32(q,w1)

DIV32      PROC FAR

           PUSH    BP
           MOV     BP,SP
           MOV     AX,[BP+8]
           MOV     DX,[BP+10]
           DIV     WORD PTR [BP+6]
           POP     BP
           RET     6H

DIV32      ENDP


; w0=Mod32(q,w1)

MOD32      PROC FAR

           PUSH    BP
           MOV     BP,SP
           MOV     AX,[BP+8]
           MOV     DX,[BP+10]
           DIV     WORD PTR [BP+6]
           MOV     AX,DX
           POP     BP
           RET     6H

MOD32      ENDP

; wRemainder = MDiv32(pDoubleWd, wDivsor)
;    quotient is put back into the double word occupied by the dividend

MDiv32	PROC	FAR

	push	BP
	mov	BP, SP
	les	SI, DWORD PTR [BP+8]

	mov	AX, ES:[SI+2]
	xor	DX, DX
	div	WORD PTR [BP+6]
	mov	ES: [SI+2], AX

	mov	AX, ES: [SI]
	div	WORD PTR [BP+6]
	mov	ES: [SI], AX
	mov	AX, DX

	pop	BP
	ret	6
MDiv32	ENDP

Math32     ENDS

           END
