;
;	LowMem_All.Asm
;
;
; This module is linked first in a CTOS link list.  The first 1K is for
; interrupt vectors, and the next section is for OS structures which must
; be in low memory.
;
; Note: the class name 'LowMem' must not be changed as it is refered to in
; other modules in the OS.
;
;
; *********************** SKULL AND CROSSBONES **************************
;
;                READ THIS BEFORE EDITING THIS MODULE
;
; On a PC, the first 600h bytes are NOT loaded from the .img file - so, 
; do not put any initialized data in the first 600h bytes.
;
; Also, memory above 700h cannot be initialized or even depended upon to
; be zero.  This is because RealNub.asm MAY decompress the boot image into
; extended memory, in which case, lowmem is ASSUMED to be unitialized
; data (except for 600h-6ffh). In other words, the decompression of lowmem
; into actual low memory does not happen.
;
; Memory in the range 600h-6ffh can be initialized in this module because
; PMake starts compression at 700h.  In other words, this memory is not
; compressed, so decompression is not required.
;
; In summary, lowmem on PCs should look like this.
;
; 000h to 5ffh          - UNitialized data
; 600h to 6ffh          - initialized data
; 700h to end of lowmem - UNitialized data
;
; If you need to initialize a piece of lowmem in the uninitialized range, do
; the initialization in OS init code.
;
; A rememdy to the lack of initialization support would be revise PMake 
; so that decompression starts beyond 700h (see the literal cParLowMem in
; PMake.plm).  However, this would make .img files larger. 
; *************************************************************************

%if(NOT %*isDef(%MF)) THEN (%Define(MF)(0))FI

PUBLIC IntVector, rgPublic

%if(%MF) THEN (
PUBLIC Fbis, nmiExch
) ELSE (
PUBLIC XBIS
)FI

EXTRN gen:BYTE

%SegName SEGMENT PUBLIC 'LowMem'

IntVector LABEL WORD
	DB 400h DUP (0)


ORG 100h
	rgPublic LABEL WORD

%if(%MF)then(
ORG 1F8h
CdtLoc	EQU 802h
	Dw	0
	Dw	((CdtLoc AND 0FFh)*100h)+((CdtLoc And 0FF00h)/100h)	; This is the linear offset of the Cdt
)fi

ORG 400h

%if(%MF)then(
FBusSeg segment public 'FBusSeg'	;  This must be location 400h
Fbis    db 10h dup (?)
nmiExch dw 0FFFFh
	DB 1E0h DUP (0)
; This is location 600h.  The RealInterface finger area is here.
	DB 200h DUP (0)
FBusSeg ends


; In real mode, this is location 420h.
; In protected mode, this is location 800h.
; CdtSeg starts with 2-byte pad, so cdtLoc is 422h or 802h.
CdtSeg	Segment	Public	'CDT'
CdtSeg	Ends

%if(%uva)then(
; Unisys Value Added - reserve memory used by bootrom so no state is lost in 
; crashdumps.
NullSeg SEGMENT PUBLIC 'Null'
DB 1000h DUP(0)
NullSeg ENDS
)fi



) ELSE (%' NGen

	XBIS LABEL BYTE


; reserve for worst case, v series on PC
;   400h - 5FFh - BIOS data
;   600h - 603h - "Gen" structure for the Knob;
;   604h - 67Fh - Debugger, boot and dump parameters for CTOS III
;                 (used to be the finger area for CTOS III)     
;   680h - AFFh - SwitchNub (see psInterface_v.plm)
;   B00h - CFFh - used by crash dump part of switchnub to read partition table
	DB 900h DUP (0)

)fi
	ORG		600h     ;
	DD		gen      ;pointer to the gen structure for the Knob 
	ORG		604h     ;start of CTOS III parameter area check in CTOStypes.edf
                     ;and RMOSSwitch_v.asm before messing with.

%SegName ENDS
END

;LOG
;
; 3/3/83 by Jeff Krause: Combined declarations for MpLowMem, LowMem, and
;	AwsLom.  Extended IWS IntVec to full 1K.  Moved IWS-MP and AWS
;	character maps into LowMem segment.  Assigned public symbol to map.
;
; 4/12/83 by Jeff Krause: changed seg name from IntVec to filename.
; 6/24/83 by Jim Frandeen: No more Sp and Mp versions
; 11/16/83 by JK: move t1 charmap to F800:0
; 3/14/84 by JK: add XBIS to NGen.
; 10/15/84 by JA: Reserve room for AltRqInterface at 410h after XBIS. This
;    moves the charactermap to 420h.
; 2/14/85 by JA: undo last change. Add DD rgSysgen at int vector 0.
; 9/18/85 by JM: add loadall and finger reserved memory.
; 4/16/86 by DR: CharacterMap not in absolute segment for NGen.
;   pCharacterMap now initialized with code in InitVid_t1.asm
;11/14/87 by JA: merge 9.9 as real mode version.
;7/11/88 by JA: merge MF for 2.3 version.
;9/9/88 by JA: Make Cdt at 802h instead of 422h, so finger area can be at 400h.
;1/3/88 by JM: reserve 4K for Unisys
; 11/16/92 JF: stash pointer to Gen record at 0 so we can find it in order
; to modify the .img file.
; 12/08/92 JF: Move pointer to gen record to 600h so that PCs will work.
; 03/08/93 DR: Added comments at beginning - SKULL AND CROSSBONES
; 06/23/93 FW: Changed comments - finger area in CTOS III replaced with 
;              file debugger info and bootstrap and crashdump info needed
;              by RMOSSwitch whilst in real mode.
; 06/28/93 FW: OOps, the gen pointer was at 600h in the finger area, but not
;              described in the comments, documented in CTOStypes.edf or 
;              in RMOSSwitch_v.asm, who is (was?) the sole user of the former
;              finger area.  
